/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.scoreboard.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.model.event.player.PlayerQuitEvent;
import net.flectone.pulse.module.message.format.scoreboard.ScoreboardModule;

@Singleton
public class ScoreboardPulseListener
implements PulseListener {
    private final ScoreboardModule scoreboardModule;

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.scoreboardModule.create(fPlayer, false);
    }

    @Pulse
    public void onPlayerLoadEvent(PlayerLoadEvent event) {
        if (!event.isReload()) {
            return;
        }
        FPlayer fPlayer = event.getPlayer();
        this.scoreboardModule.create(fPlayer, true);
    }

    @Pulse
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.scoreboardModule.remove(fPlayer);
    }

    @Inject
    @Generated
    public ScoreboardPulseListener(ScoreboardModule scoreboardModule) {
        this.scoreboardModule = scoreboardModule;
    }
}

