/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.quit.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.adventure.text.TranslatableComponent;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.model.event.player.PlayerQuitEvent;
import net.flectone.pulse.module.message.quit.QuitModule;

@Singleton
public class QuitPulseListener
implements PulseListener {
    private final QuitModule quitModule;

    @Pulse
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.quitModule.send(fPlayer, false);
    }

    @Pulse
    public void onTranslatableMessageReceive(MessageReceiveEvent event) {
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent == null) {
            return;
        }
        String translationKey = translatableComponent.key();
        if (!translationKey.equals("multiplayer.player.left")) {
            return;
        }
        event.setCancelled(true);
    }

    @Inject
    @Generated
    public QuitPulseListener(QuitModule quitModule) {
        this.quitModule = quitModule;
    }
}

