/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sidebar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.score.ScoreFormat;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.module.message.sidebar.listener.SidebarPulseListener;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class SidebarModule
extends AbstractModuleListLocalization<Localization.Message.Sidebar> {
    private final Map<UUID, List<String>> playerSidebar = new HashMap<UUID, List<String>>();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final MessagePipeline messagePipeline;
    private final PacketSender packetSender;
    private final ListenerRegistry listenerRegistry;
    private final PacketProvider packetProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::update), ticker.getPeriod());
        }
        this.listenerRegistry.register(SidebarPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.fPlayerService.getOnlineFPlayers().forEach(this::remove);
    }

    @Override
    public MessageType messageType() {
        return MessageType.SIDEBAR;
    }

    @Override
    public Message.Sidebar config() {
        return this.fileResolver.getMessage().getSidebar();
    }

    @Override
    public Permission.Message.Sidebar permission() {
        return this.fileResolver.getPermission().getMessage().getSidebar();
    }

    @Override
    public Localization.Message.Sidebar localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getSidebar();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return this.joinMultiList(this.localization(fPlayer).getValues());
    }

    public void remove(FPlayer fPlayer) {
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerScoreboardObjective(this.createObjectiveName(fPlayer), WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, null, null));
    }

    public void update(FPlayer fPlayer) {
        this.send(fPlayer, WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE);
    }

    public void create(UUID uuid) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        this.create(fPlayer);
    }

    public void create(FPlayer fPlayer) {
        this.remove(fPlayer);
        this.send(fPlayer, WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE);
    }

    @Async
    public void send(FPlayer fPlayer, WrapperPlayServerScoreboardObjective.ObjectiveMode objectiveMode) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.getNextMessage(fPlayer, this.config().isRandom());
        if (format == null) {
            return;
        }
        String[] lines = format.split("<br>");
        if (lines.length == 0) {
            return;
        }
        String objectiveName = this.createObjectiveName(fPlayer);
        Component title = this.messagePipeline.builder(fPlayer, lines[0]).build();
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerScoreboardObjective(objectiveName, objectiveMode, title, WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore()));
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerDisplayScoreboard(1, objectiveName));
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.modernSidebarLines(fPlayer, objectiveName, lines);
        } else {
            this.legacySidebarLines(fPlayer, objectiveName, lines);
        }
    }

    private void modernSidebarLines(FPlayer fPlayer, String objectiveName, String[] lines) {
        for (int i = 1; i < lines.length; ++i) {
            int lineIndex = i - 1;
            String lineId = this.createLineId(lineIndex, fPlayer);
            Component line = this.messagePipeline.builder(fPlayer, lines[i]).build();
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerUpdateScore(lineId, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, objectiveName, lines.length - lineIndex, line, (ScoreFormat)ScoreFormat.blankScore()));
        }
    }

    private void legacySidebarLines(FPlayer fPlayer, String objectiveName, String[] lines) {
        int i;
        List sidebars = this.playerSidebar.getOrDefault(fPlayer.getUuid(), new ArrayList(15));
        for (i = 0; i < sidebars.size(); ++i) {
            String oldLine = (String)sidebars.get(i);
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerUpdateScore(oldLine, WrapperPlayServerUpdateScore.Action.REMOVE_ITEM, objectiveName, lines.length - i, null, null));
        }
        for (i = 1; i < lines.length; ++i) {
            int lineIndex = i - 1;
            String line = this.messagePipeline.builder(fPlayer, lines[i]).legacySerializerBuild();
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerUpdateScore(line, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, objectiveName, lines.length - lineIndex, null, null));
            if (lineIndex < sidebars.size()) {
                sidebars.set(lineIndex, line);
                continue;
            }
            sidebars.add(line);
        }
        this.playerSidebar.put(fPlayer.getUuid(), sidebars);
    }

    private String createObjectiveName(FPlayer fPlayer) {
        return "sb_" + String.valueOf(fPlayer.getUuid());
    }

    private String createLineId(int index, FPlayer fPlayer) {
        return "ln_" + index + "_" + String.valueOf(fPlayer.getUuid());
    }

    @Inject
    @Generated
    public SidebarModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, MessagePipeline messagePipeline, PacketSender packetSender, ListenerRegistry listenerRegistry, PacketProvider packetProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.messagePipeline = messagePipeline;
        this.packetSender = packetSender;
        this.listenerRegistry = listenerRegistry;
        this.packetProvider = packetProvider;
    }
}

