/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.icon;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.IconUtil;
import net.flectone.pulse.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

@Singleton
public class IconModule
extends AbstractModule {
    private final List<String> iconList = new ArrayList<String>();
    private final FileResolver fileResolver;
    private final PlatformServerAdapter platformServerAdapter;
    private final RandomUtil randomUtil;
    private final IconUtil iconUtil;
    @Named(value="imagePath")
    private final Path iconPath;
    private int index;

    @Override
    public void onEnable() {
        super.onEnable();
        this.initIcons();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.iconList.clear();
    }

    @Override
    public Message.Status.Icon config() {
        return this.fileResolver.getMessage().getStatus().getIcon();
    }

    @Override
    public Permission.Message.Status.Icon permission() {
        return this.fileResolver.getPermission().getMessage().getStatus().getIcon();
    }

    public void initIcons() {
        List<String> iconNames = this.config().getValues();
        if (iconNames.isEmpty()) {
            return;
        }
        iconNames.forEach(iconName -> {
            if (new File(this.iconPath.toString() + File.separator + iconName).exists()) {
                return;
            }
            this.platformServerAdapter.saveResource("images" + File.separator + iconName);
        });
        File folder = new File(this.iconPath.toString());
        if (!folder.isDirectory()) {
            return;
        }
        File[] icons = folder.listFiles();
        if (icons == null) {
            return;
        }
        iconNames.forEach(iconName -> {
            for (File icon : icons) {
                String convertedIcon;
                if (!icon.isFile() || !icon.getName().equals(iconName) || (convertedIcon = this.iconUtil.convertIcon(icon)) == null) continue;
                this.iconList.add(convertedIcon);
            }
        });
    }

    @Nullable
    public String next(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        if (this.iconList.isEmpty()) {
            return null;
        }
        if (this.config().isRandom()) {
            this.index = this.randomUtil.nextInt(0, this.iconList.size());
        } else {
            ++this.index;
            this.index %= this.iconList.size();
        }
        return this.iconList.get(this.index);
    }

    @Inject
    @Generated
    public IconModule(FileResolver fileResolver, PlatformServerAdapter platformServerAdapter, RandomUtil randomUtil, IconUtil iconUtil, @Named(value="imagePath") Path iconPath) {
        this.fileResolver = fileResolver;
        this.platformServerAdapter = platformServerAdapter;
        this.randomUtil = randomUtil;
        this.iconUtil = iconUtil;
        this.iconPath = iconPath;
    }
}

