/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.players;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.status.players.listener.PlayersPulseListener;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class PlayersModule
extends AbstractModuleLocalization<Localization.Message.Status.Players> {
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;
    private final PlatformServerAdapter platformServerAdapter;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getBypass());
        this.listenerRegistry.register(PlayersPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.PLAYERS;
    }

    @Override
    public Message.Status.Players config() {
        return this.fileResolver.getMessage().getStatus().getPlayers();
    }

    @Override
    public Permission.Message.Status.Players permission() {
        return this.fileResolver.getPermission().getMessage().getStatus().getPlayers();
    }

    @Override
    public Localization.Message.Status.Players localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getStatus().getPlayers();
    }

    public boolean isAllowed(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return true;
        }
        if (!this.config().isControl()) {
            return true;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return true;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission().getBypass())) {
            return true;
        }
        int online = this.platformServerAdapter.getOnlinePlayerCount();
        return online < this.config().getMax();
    }

    public List<Localization.Message.Status.Players.Sample> getSamples(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.localization(fPlayer).getSamples();
    }

    @Inject
    @Generated
    public PlayersModule(FileResolver fileResolver, PermissionChecker permissionChecker, PlatformServerAdapter platformServerAdapter, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
        this.platformServerAdapter = platformServerAdapter;
        this.listenerRegistry = listenerRegistry;
    }
}

