/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.players.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerPreLoginEvent;
import net.flectone.pulse.module.message.status.players.PlayersModule;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class PlayersPulseListener
implements PulseListener {
    private final PlayersModule playersModule;
    private final FPlayerService fPlayerService;
    private final MessagePipeline messagePipeline;

    @Pulse
    public void onPlayerPreLoginEvent(PlayerPreLoginEvent event) {
        FPlayer fPlayer = event.getPlayer();
        if (this.playersModule.isAllowed(fPlayer)) {
            return;
        }
        event.setAllowed(false);
        this.fPlayerService.loadColors(fPlayer);
        String reasonMessage = this.playersModule.localization(fPlayer).getFull();
        Component reason = this.messagePipeline.builder(fPlayer, reasonMessage).build();
        event.setKickReason(reason);
    }

    @Inject
    @Generated
    public PlayersPulseListener(PlayersModule playersModule, FPlayerService fPlayerService, MessagePipeline messagePipeline) {
        this.playersModule = playersModule;
        this.fPlayerService = fPlayerService;
        this.messagePipeline = messagePipeline;
    }
}

