/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.tab.footer;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPlayerListHeaderAndFooter;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.module.message.tab.footer.listener.FooterPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class FooterModule
extends AbstractModuleListLocalization<Localization.Message.Tab.Footer> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;
    private final PacketSender packetSender;

    @Override
    public void onEnable() {
        super.onEnable();
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(FooterPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        Destination.Type destinationType = this.config().getDestination().getType();
        if (destinationType == Destination.Type.TAB_HEADER || destinationType == Destination.Type.TAB_FOOTER) {
            this.packetSender.send((PacketWrapper<?>)new WrapperPlayServerPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty()));
        }
    }

    @Override
    public MessageType messageType() {
        return MessageType.FOOTER;
    }

    @Override
    public Message.Tab.Footer config() {
        return this.fileResolver.getMessage().getTab().getFooter();
    }

    @Override
    public Permission.Message.Tab.Footer permission() {
        return this.fileResolver.getPermission().getMessage().getTab().getFooter();
    }

    @Override
    public Localization.Message.Tab.Footer localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getTab().getFooter();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return this.joinMultiList(this.localization(fPlayer).getLists());
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.getNextMessage(fPlayer, this.config().isRandom());
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(this.config().getDestination())).build());
    }

    @Inject
    @Generated
    public FooterModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry, PacketSender packetSender) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
        this.packetSender = packetSender;
    }
}

