/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.adapter;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.key.Key;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.TranslatableComponent;
import net.flectone.pulse.library.adventure.text.event.HoverEvent;
import net.flectone.pulse.library.adventure.text.event.HoverEventSource;
import net.flectone.pulse.library.adventure.text.format.TextDecoration;
import net.flectone.pulse.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.flectone.pulse.library.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.flectone.pulse.library.adventure.translation.GlobalTranslator;
import net.flectone.pulse.library.cloud.cloud.type.tuple.Pair;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.impl.util.SpigotConversionUtil;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.component.ComponentTypes;
import net.flectone.pulse.library.packetevents.protocol.component.builtin.item.ItemLore;
import net.flectone.pulse.library.packetevents.protocol.item.ItemStack;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.tab.playerlist.PlayerlistnameModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.PlatformType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class BukkitServerAdapter
implements PlatformServerAdapter {
    private final Plugin plugin;
    private final Provider<IntegrationModule> integrationModuleProvider;
    private final Provider<FPlayerService> fPlayerServiceProvider;
    private final Provider<MessagePipeline> messagePipelineProvider;
    private final Provider<PlayerlistnameModule> playerlistnameModuleProvider;
    private final PacketProvider packetProvider;
    private final ReflectionResolver reflectionResolver;
    private Pair<MethodHandle, Object> getTPSMethodPair;

    @Override
    @Sync
    public void dispatchCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    @NotNull
    public String getTPS() {
        if (this.getTPSMethodPair == null) {
            this.getTPSMethodPair = this.findGetTPSMethod();
        }
        try {
            double[] recentTps = ((MethodHandle)this.getTPSMethodPair.first()).invoke(this.getTPSMethodPair.second());
            double tps = Math.min((double)Math.round(recentTps[0] * 10.0) / 10.0, 20.0);
            return String.valueOf(tps);
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    public Pair<MethodHandle, Object> findGetTPSMethod() {
        Object minecraftServer = Bukkit.getServer();
        MethodHandle getTPS = this.reflectionResolver.unreflectMethod(Server.class, "getTPS", new Class[0]);
        if (getTPS == null) {
            try {
                minecraftServer = this.getLegacyMinecraftServer();
                Field recentTpsField = minecraftServer.getClass().getSuperclass().getDeclaredField("recentTps");
                getTPS = this.reflectionResolver.unreflect(lookup -> lookup.unreflectGetter(recentTpsField));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return Pair.of((Object)getTPS, (Object)minecraftServer);
    }

    private Object getLegacyMinecraftServer() throws ReflectiveOperationException {
        Server server = Bukkit.getServer();
        try {
            Field consoleField = server.getClass().getDeclaredField("console");
            consoleField.setAccessible(true);
            return consoleField.get(server);
        }
        catch (NoSuchFieldException e) {
            Method getServerMethod = server.getClass().getMethod("getServer", new Class[0]);
            return getServerMethod.invoke((Object)server, new Object[0]);
        }
    }

    @Override
    @NotNull
    public JsonElement getMOTD() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", Bukkit.getServer().getMotd());
        return jsonObject;
    }

    @Override
    public int getMaxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    @Override
    public int getOnlinePlayerCount() {
        return ((PlayerlistnameModule)this.playerlistnameModuleProvider.get()).isProxyMode() ? (int)((FPlayerService)this.fPlayerServiceProvider.get()).findOnlineFPlayers().stream().filter(fPlayer -> !((IntegrationModule)this.integrationModuleProvider.get()).isVanished((FEntity)fPlayer)).count() : (int)((FPlayerService)this.fPlayerServiceProvider.get()).getOnlineFPlayers().stream().filter(fPlayer -> !fPlayer.isUnknown()).filter(fPlayer -> !((IntegrationModule)this.integrationModuleProvider.get()).isVanished((FEntity)fPlayer)).count();
    }

    @Override
    @NotNull
    public String getServerCore() {
        return Bukkit.getServer().getName();
    }

    @Override
    @NotNull
    public String getServerUUID() {
        List worlds = Bukkit.getWorlds();
        if (worlds.isEmpty()) {
            return "";
        }
        return ((World)J_U_List.getFirst(worlds)).getUID().toString();
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.BUKKIT;
    }

    @Override
    public boolean hasProject(String projectName) {
        return Bukkit.getPluginManager().getPlugin(projectName) != null;
    }

    @Override
    public boolean isOnlineMode() {
        return Bukkit.getServer().getOnlineMode();
    }

    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    @NotNull
    public ItemStack buildItemStack(FPlayer fPlayer, String material, String title, String lore) {
        String[] stringArray;
        String[] stringsLore = lore.split("<br>");
        if (stringsLore.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lore;
        } else {
            stringArray = stringsLore;
        }
        return this.buildItemStack(fPlayer, material, title, stringArray);
    }

    @Override
    @NotNull
    public ItemStack buildItemStack(FPlayer fPlayer, String material, String title, String[] lore) {
        List<Component> componentLore;
        Material itemMaterial;
        try {
            itemMaterial = Material.valueOf((String)material);
        }
        catch (IllegalArgumentException e) {
            itemMaterial = Material.DIAMOND_BLOCK;
        }
        Component componentName = this.buildItemNameComponent(fPlayer, title);
        List<Component> list = componentLore = lore.length == 0 ? Collections.emptyList() : Arrays.stream(lore).map(message -> ((MessagePipeline)this.messagePipelineProvider.get()).builder(fPlayer, (String)message).build().decoration(TextDecoration.ITALIC, false)).toList();
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            return this.buildModernItemStack(itemMaterial, componentName, componentLore);
        }
        return this.buildLegacyItemStack(itemMaterial, componentName, componentLore);
    }

    @NotNull
    private Component buildItemNameComponent(@NotNull FPlayer fPlayer, @NotNull String title) {
        return title.isEmpty() ? Component.empty() : ((MessagePipeline)this.messagePipelineProvider.get()).builder(fPlayer, title).build();
    }

    @NotNull
    private ItemStack buildModernItemStack(@NotNull Material material, @NotNull Component name, @NotNull List<Component> lore) {
        return new ItemStack.Builder().type(SpigotConversionUtil.fromBukkitItemMaterial((Material)material)).component(ComponentTypes.ITEM_NAME, (Object)name).component(ComponentTypes.LORE, (Object)new ItemLore(lore)).build();
    }

    @NotNull
    private ItemStack buildLegacyItemStack(@NotNull Material material, @NotNull Component name, @NotNull List<Component> lore) {
        org.bukkit.inventory.ItemStack legacyItem = new org.bukkit.inventory.ItemStack(material);
        ItemMeta meta = legacyItem.getItemMeta();
        LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
        meta.setDisplayName(legacyComponentSerializer.serialize(name));
        meta.setLore(lore.stream().map(component -> legacyComponentSerializer.serialize(name)).toList());
        legacyItem.setItemMeta(meta);
        return SpigotConversionUtil.fromBukkitItemStack((org.bukkit.inventory.ItemStack)legacyItem);
    }

    @Override
    @NotNull
    public String getItemName(@Nullable Object itemStack) {
        if (!(itemStack instanceof org.bukkit.inventory.ItemStack)) {
            return "";
        }
        org.bukkit.inventory.ItemStack bukkitItem = (org.bukkit.inventory.ItemStack)itemStack;
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return this.getModernItemName(bukkitItem.getType());
        }
        return this.getLegacyItemName(bukkitItem);
    }

    @Override
    @Nullable
    public InputStream getResource(String path) {
        return this.plugin.getResource(path);
    }

    @Override
    public void saveResource(String path) {
        this.plugin.saveResource(path, false);
    }

    @NotNull
    private String getModernItemName(@NotNull Material material) {
        return (material.isBlock() ? "block" : "item") + ".minecraft." + material.toString().toLowerCase();
    }

    @NotNull
    private String getLegacyItemName(@NotNull org.bukkit.inventory.ItemStack itemStack) {
        try {
            Object nmsStack = itemStack.getClass().getMethod("asNMSCopy", org.bukkit.inventory.ItemStack.class).invoke(null, itemStack);
            Object item = nmsStack.getClass().getMethod("getItem", new Class[0]).invoke(nmsStack, new Object[0]);
            return (String)item.getClass().getMethod("getName", new Class[0]).invoke(item, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    @NotNull
    public Component translateItemName(Object item, boolean translatable) {
        Component component;
        if (!(item instanceof org.bukkit.inventory.ItemStack)) {
            return Component.empty();
        }
        org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)item;
        Component component2 = component = itemStack.getItemMeta() == null || itemStack.getItemMeta().getDisplayName() == null || itemStack.getItemMeta().getDisplayName().isEmpty() ? this.createTranslatableItemName(itemStack, translatable) : this.createItemMetaName(itemStack);
        if (itemStack.getType() == Material.AIR) {
            return component;
        }
        Key key = Key.key((String)itemStack.getType().name().toLowerCase());
        int amount = itemStack.getAmount();
        return component.hoverEvent((HoverEventSource)HoverEvent.showItem((Key)key, (int)amount));
    }

    private Component createItemMetaName(org.bukkit.inventory.ItemStack itemStack) {
        String displayName = itemStack.getItemMeta().getDisplayName();
        if (displayName == null) {
            return Component.empty();
        }
        Component componentName = ((MessagePipeline)this.messagePipelineProvider.get()).builder(displayName).build();
        String clearedDisplayName = PlainTextComponentSerializer.plainText().serialize(componentName);
        return Component.text((String)clearedDisplayName).decorate(TextDecoration.ITALIC);
    }

    private Component createTranslatableItemName(org.bukkit.inventory.ItemStack itemStack, boolean translatable) {
        String itemName = this.getItemName(itemStack);
        TranslatableComponent itemComponent = Component.translatable((String)itemName);
        return translatable ? itemComponent : GlobalTranslator.render((Component)itemComponent, (Locale)Locale.ROOT);
    }

    @Inject
    @Generated
    public BukkitServerAdapter(Plugin plugin, Provider<IntegrationModule> integrationModuleProvider, Provider<FPlayerService> fPlayerServiceProvider, Provider<MessagePipeline> messagePipelineProvider, Provider<PlayerlistnameModule> playerlistnameModuleProvider, PacketProvider packetProvider, ReflectionResolver reflectionResolver) {
        this.plugin = plugin;
        this.integrationModuleProvider = integrationModuleProvider;
        this.fPlayerServiceProvider = fPlayerServiceProvider;
        this.messagePipelineProvider = messagePipelineProvider;
        this.playerlistnameModuleProvider = playerlistnameModuleProvider;
        this.packetProvider = packetProvider;
        this.reflectionResolver = reflectionResolver;
    }
}

