/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.handler;

import java.util.Objects;
import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.exception.ArgumentParseException;
import net.flectone.pulse.library.cloud.cloud.exception.CommandExecutionException;
import net.flectone.pulse.library.cloud.cloud.exception.InvalidSyntaxException;
import net.flectone.pulse.library.cloud.cloud.exception.NoPermissionException;
import net.flectone.pulse.library.cloud.cloud.exception.handling.ExceptionContext;
import net.flectone.pulse.library.cloud.cloud.exception.parsing.NumberParseException;
import net.flectone.pulse.library.cloud.cloud.parser.standard.BooleanParser;
import net.flectone.pulse.library.cloud.cloud.parser.standard.DurationParser;
import net.flectone.pulse.library.cloud.cloud.parser.standard.StringParser;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class CommandExceptionHandler {
    private final FileResolver fileResolver;
    private final EventDispatcher eventDispatcher;
    private final MessagePipeline messagePipeline;
    private final FLogger fLogger;

    public void handleArgumentParseException(ExceptionContext<FPlayer, ArgumentParseException> context) {
        Throwable throwable;
        FPlayer fPlayer = (FPlayer)context.context().sender();
        Localization.Command.Exception localizationException = this.fileResolver.getLocalization(fPlayer).getCommand().getException();
        Throwable throwable2 = throwable = ((ArgumentParseException)context.exception()).getCause();
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        String message = switch (CommandExceptionHandler.jvmdowngrader$switch$handleArgumentParseException$0(throwable3, n)) {
            case 0 -> {
                BooleanParser.BooleanParseException e = (BooleanParser.BooleanParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseBoolean(), "<input>", e.input());
            }
            case 1 -> {
                NumberParseException e = (NumberParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseNumber(), "<input>", e.input());
            }
            case 2 -> {
                DurationParser.DurationParseException e = (DurationParser.DurationParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseNumber(), "<input>", e.input());
            }
            case 3 -> {
                StringParser.StringParseException e = (StringParser.StringParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseString(), "<input>", e.input());
            }
            default -> Strings.CS.replace(localizationException.getParseUnknown(), "<input>", String.valueOf(throwable.getMessage()));
        };
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleInvalidSyntaxException(ExceptionContext<FPlayer, InvalidSyntaxException> context) {
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String correctSyntax = ((InvalidSyntaxException)context.exception()).correctSyntax();
        String message = StringUtils.replaceEach((String)this.fileResolver.getLocalization(fPlayer).getCommand().getException().getSyntax(), (String[])new String[]{"<correct_syntax>", "<command>"}, (String[])new String[]{correctSyntax, String.valueOf(correctSyntax.split(" ")[0])});
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleNoPermissionException(ExceptionContext<FPlayer, NoPermissionException> context) {
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String message = this.fileResolver.getLocalization(fPlayer).getCommand().getException().getPermission();
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleCommandExecutionException(ExceptionContext<FPlayer, CommandExecutionException> context) {
        this.fLogger.warning(context.exception());
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String message = Strings.CS.replace(this.fileResolver.getLocalization(fPlayer).getCommand().getException().getExecution(), "<exception>", ((CommandExecutionException)context.exception()).getMessage());
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    private void send(FPlayer fPlayer, Component component) {
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.ERROR, fPlayer, component));
    }

    @Inject
    @Generated
    public CommandExceptionHandler(FileResolver fileResolver, EventDispatcher eventDispatcher, MessagePipeline messagePipeline, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.eventDispatcher = eventDispatcher;
        this.messagePipeline = messagePipeline;
        this.fLogger = fLogger;
    }

    private static /* synthetic */ int jvmdowngrader$switch$handleArgumentParseException$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 4) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bounds for length " + 4);
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof BooleanParser.BooleanParseException) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof NumberParseException) {
                        n2 = 1;
                        break;
                    }
                }
                case 2: {
                    if (object instanceof DurationParser.DurationParseException) {
                        n2 = 2;
                        break;
                    }
                }
                case 3: {
                    if (object instanceof StringParser.StringParseException) {
                        n2 = 3;
                        break;
                    }
                }
                default: {
                    n2 = 4;
                }
            }
        }
        return n2;
    }
}

