/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.provider;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.provider.AttributesProvider;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Singleton
public class LegacyAttributesProvider
implements AttributesProvider {
    @Override
    public double getArmorValue(Player player) {
        ItemStack[] armorContents;
        double armorPoints = 0.0;
        for (ItemStack item : armorContents = player.getInventory().getArmorContents()) {
            if (item == null) continue;
            String type = item.getType().name();
            if (type.endsWith("_HELMET")) {
                armorPoints += 1.0;
                continue;
            }
            if (type.endsWith("_CHESTPLATE")) {
                armorPoints += 3.0;
                continue;
            }
            if (type.endsWith("_LEGGINGS")) {
                armorPoints += 2.0;
                continue;
            }
            if (!type.endsWith("_BOOTS")) continue;
            armorPoints += 1.0;
        }
        return armorPoints;
    }

    @Override
    public double getAttackDamage(Player player) {
        ItemStack hand = player.getInventory().getItemInHand();
        if (hand == null) {
            return 1.0;
        }
        String type = hand.getType().name();
        if (type.contains("DIAMOND_SWORD")) {
            return 7.0;
        }
        if (type.contains("IRON_SWORD")) {
            return 6.0;
        }
        if (type.contains("STONE_SWORD")) {
            return 5.0;
        }
        if (type.contains("WOOD_SWORD")) {
            return 4.0;
        }
        return 1.0;
    }

    @Inject
    @Generated
    public LegacyAttributesProvider() {
    }
}

