/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.BukkitBaseListener;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@Singleton
public class BukkitListenerRegistry
extends ListenerRegistry {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final Plugin plugin;
    private final Injector injector;

    @Inject
    public BukkitListenerRegistry(Plugin plugin, FLogger fLogger, Injector injector, PacketProvider packetProvider) {
        super(fLogger, injector, packetProvider);
        this.plugin = plugin;
        this.injector = injector;
    }

    @Override
    public void register(Class<?> clazzListener, Event.Priority eventPriority) {
        if (Listener.class.isAssignableFrom(clazzListener)) {
            Listener bukkitListener = (Listener)this.injector.getInstance(clazzListener);
            this.register(bukkitListener, EventPriority.valueOf((String)eventPriority.name()));
            return;
        }
        super.register(clazzListener, eventPriority);
    }

    public void register(Listener bukkitListener, EventPriority eventPriority) {
        this.listeners.add(bukkitListener);
        this.registerEvents(bukkitListener, eventPriority);
    }

    private void registerEvents(Listener abstractListener, EventPriority eventPriority) {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (Method method : abstractListener.getClass().getMethods()) {
            EventHandler eventHandler = method.getAnnotation(EventHandler.class);
            if (eventHandler == null || method.isBridge() || method.isSynthetic()) continue;
            Class<Event> eventClass = method.getParameterTypes()[0].asSubclass(Event.class);
            method.setAccessible(true);
            EventExecutor executor = (listener, event) -> {
                try {
                    if (!eventClass.isAssignableFrom(event.getClass())) {
                        return;
                    }
                    method.invoke((Object)listener, event);
                }
                catch (InvocationTargetException ex) {
                    throw new EventException(ex.getCause());
                }
                catch (Throwable t) {
                    throw new EventException(t);
                }
            };
            pluginManager.registerEvent(eventClass, abstractListener, eventPriority, executor, this.plugin, false);
        }
    }

    @Override
    public void unregisterAll() {
        super.unregisterAll();
        this.listeners.forEach(HandlerList::unregisterAll);
        this.listeners.clear();
    }

    @Override
    public void registerDefaultListeners() {
        super.registerDefaultListeners();
        this.register(BukkitBaseListener.class, Event.Priority.LOWEST);
    }
}

