/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.proxy.BukkitProxy;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class BukkitProxyRegistry
extends ProxyRegistry {
    private final FileResolver fileResolver;
    private final Injector injector;

    @Inject
    public BukkitProxyRegistry(FileResolver fileResolver, ReflectionResolver reflectionResolver, FLogger fLogger, Injector injector) {
        super(fileResolver, reflectionResolver, fLogger, injector);
        this.fileResolver = fileResolver;
        this.injector = injector;
    }

    @Override
    public void onEnable() {
        boolean isBukkitProxyEnable;
        super.onEnable();
        Config config = this.fileResolver.getConfig();
        boolean bl = isBukkitProxyEnable = config.getProxy().isBungeecord() || config.getProxy().isVelocity();
        if (isBukkitProxyEnable) {
            this.warnIfLocalDatabase();
            BukkitProxy bukkitProxy = (BukkitProxy)this.injector.getInstance(BukkitProxy.class);
            bukkitProxy.onEnable();
            this.registry(bukkitProxy);
        }
    }
}

