/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import com.mojang.brigadier.arguments.StringArgumentType;
import io.leangen.geantyref.TypeToken;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.cloud.cloud.CloudCapability;
import net.flectone.pulse.library.cloud.cloud.brigadier.BrigadierSetting;
import net.flectone.pulse.library.cloud.cloud.brigadier.CloudBrigadierManager;
import net.flectone.pulse.library.cloud.cloud.bukkit.CloudBukkitCapabilities;
import net.flectone.pulse.library.cloud.cloud.parser.standard.StringParser;
import net.flectone.pulse.library.cloud.cloud.setting.Setting;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.platform.handler.CommandExceptionHandler;
import net.flectone.pulse.platform.registry.LegacyBukkitCommandRegistry;
import net.flectone.pulse.processing.mapper.FPlayerMapper;
import net.flectone.pulse.processing.parser.integer.ColorParser;
import net.flectone.pulse.processing.parser.integer.DurationReasonParser;
import net.flectone.pulse.processing.parser.player.PlayerParser;
import net.flectone.pulse.processing.parser.string.MessageParser;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import org.bukkit.plugin.Plugin;

@Singleton
public class ModernBukkitCommandRegistry
extends LegacyBukkitCommandRegistry {
    private final Config config;
    private final ReflectionResolver reflectionResolver;

    @Inject
    public ModernBukkitCommandRegistry(FileResolver fileResolver, ReflectionResolver reflectionResolver, CommandExceptionHandler commandExceptionHandler, Plugin plugin, FPlayerMapper fPlayerMapper) {
        super(fileResolver, commandExceptionHandler, plugin, fPlayerMapper);
        this.config = fileResolver.getConfig();
        this.reflectionResolver = reflectionResolver;
        if (this.manager.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            this.manager.registerBrigadier();
            CloudBrigadierManager brigadierManager = this.manager.brigadierManager();
            brigadierManager.setNativeSuggestions((TypeToken)new TypeToken<StringParser<FPlayer>>(this){}, true);
            brigadierManager.registerMapping((TypeToken)new TypeToken<PlayerParser>(this){}, builder -> builder.cloudSuggestions().to(argument -> StringArgumentType.string()));
            brigadierManager.registerMapping((TypeToken)new TypeToken<DurationReasonParser>(this){}, builder -> builder.cloudSuggestions().to(argument -> StringArgumentType.greedyString()));
            brigadierManager.registerMapping((TypeToken)new TypeToken<ColorParser>(this){}, builder -> builder.cloudSuggestions().to(argument -> StringArgumentType.greedyString()));
            brigadierManager.registerMapping((TypeToken)new TypeToken<MessageParser>(this){}, builder -> builder.cloudSuggestions().to(argument -> StringArgumentType.greedyString()));
            brigadierManager.settings().set((Setting)BrigadierSetting.FORCE_EXECUTABLE, true);
        } else if (this.manager.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.manager.registerAsynchronousCompletions();
        }
    }

    @Override
    public void reload() {
        if (!this.config.getCommand().isUnregisterOnReload()) {
            return;
        }
        if (this.reflectionResolver.isPaper()) {
            this.removeCommands();
        } else {
            this.syncRemoveCommands();
        }
    }
}

