/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.platform.proxy.Proxy;
import net.flectone.pulse.platform.proxy.RedisProxy;
import net.flectone.pulse.platform.registry.Registry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class ProxyRegistry
implements Registry {
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final FLogger fLogger;
    private final Injector injector;

    public boolean hasEnabledProxy() {
        return this.proxies.stream().anyMatch(Proxy::isEnable);
    }

    public void registry(Proxy proxy) {
        this.proxies.add(proxy);
    }

    public void onEnable() {
        Config.Proxy.Redis redis = this.fileResolver.getConfig().getProxy().getRedis();
        if (redis.isEnable()) {
            this.warnIfLocalDatabase();
            this.reflectionResolver.hasClassOrElse("io.lettuce.core.RedisClient", this::loadLibraries);
            RedisProxy redisProxy = (RedisProxy)this.injector.getInstance(RedisProxy.class);
            redisProxy.onEnable();
            this.registry(redisProxy);
        }
    }

    protected void warnIfLocalDatabase() {
        Config.Database database = this.fileResolver.getConfig().getDatabase();
        if (database.getType() == Database.Type.SQLITE) {
            this.fLogger.warning("SQLITE database and Proxy are incompatible");
        }
    }

    public void onDisable() {
        this.proxies.forEach(Proxy::onDisable);
        this.proxies.clear();
    }

    @Override
    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("io{}lettuce").artifactId("lettuce-core").version("6.8.1.RELEASE").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    @Inject
    @Generated
    public ProxyRegistry(FileResolver fileResolver, ReflectionResolver reflectionResolver, FLogger fLogger, Injector injector) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.fLogger = fLogger;
        this.injector = injector;
    }

    @Generated
    public List<Proxy> getProxies() {
        return this.proxies;
    }
}

