/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class DisableSender {
    private final MessagePipeline messagePipeline;
    private final EventDispatcher eventDispatcher;
    private final FileResolver fileResolver;

    public boolean sendIfDisabled(FEntity entity, FEntity receiver, MessageType messageType) {
        if (!(receiver instanceof FPlayer)) {
            return false;
        }
        FPlayer fReceiver = (FPlayer)receiver;
        if (fReceiver.isUnknown()) {
            return false;
        }
        if (fReceiver.isSetting(messageType)) {
            return false;
        }
        if (!(entity instanceof FPlayer)) {
            return true;
        }
        FPlayer fPlayer = (FPlayer)entity;
        Localization.Command.Chatsetting localization = this.fileResolver.getLocalization(fReceiver).getCommand().getChatsetting();
        String disableMessage = fPlayer.equals(fReceiver) ? localization.getDisabledSelf() : localization.getDisabledOther();
        Component component = this.messagePipeline.builder(receiver, fPlayer, disableMessage).build();
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.ERROR, fPlayer, component));
        return true;
    }

    @Inject
    @Generated
    public DisableSender(MessagePipeline messagePipeline, EventDispatcher eventDispatcher, FileResolver fileResolver) {
        this.messagePipeline = messagePipeline;
        this.eventDispatcher = eventDispatcher;
        this.fileResolver = fileResolver;
    }
}

