/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.flectone.pulse.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.flectone.pulse.library.adventure.translation.GlobalTranslator;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.advancements.Advancement;
import net.flectone.pulse.library.packetevents.protocol.advancements.AdvancementDisplay;
import net.flectone.pulse.library.packetevents.protocol.advancements.AdvancementHolder;
import net.flectone.pulse.library.packetevents.protocol.advancements.AdvancementProgress;
import net.flectone.pulse.library.packetevents.protocol.advancements.AdvancementType;
import net.flectone.pulse.library.packetevents.protocol.chat.ChatType;
import net.flectone.pulse.library.packetevents.protocol.chat.ChatTypes;
import net.flectone.pulse.library.packetevents.protocol.chat.message.ChatMessage;
import net.flectone.pulse.library.packetevents.protocol.chat.message.ChatMessageLegacy;
import net.flectone.pulse.library.packetevents.protocol.chat.message.ChatMessage_v1_16;
import net.flectone.pulse.library.packetevents.protocol.item.ItemStack;
import net.flectone.pulse.library.packetevents.protocol.item.type.ItemType;
import net.flectone.pulse.library.packetevents.protocol.item.type.ItemTypes;
import net.flectone.pulse.library.packetevents.protocol.player.ClientVersion;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.library.packetevents.resources.ResourceLocation;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerActionBar;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerBossBar;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPlayerListHeaderAndFooter;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerUpdateAdvancements;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.BossBar;
import net.flectone.pulse.model.util.Times;
import net.flectone.pulse.model.util.Toast;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.serializer.PacketSerializer;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class MessageSender {
    private final PacketSerializer packetSerializer;
    private final TaskScheduler taskScheduler;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;
    private final IntegrationModule integrationModule;
    private final FLogger fLogger;

    public void sendToConsole(Component component) {
        String consoleString = (String)ANSIComponentSerializer.ansi().serialize(GlobalTranslator.render((Component)component, (Locale)Locale.ROOT));
        this.fLogger.info(consoleString);
    }

    public void sendMessage(FPlayer fPlayer, Component component, boolean silent) {
        WrapperPlayServerSystemChatMessage chatPacket;
        if (fPlayer.isConsole()) {
            this.sendToConsole(component);
            return;
        }
        if (this.integrationModule.sendMessageWithInteractiveChat(fPlayer, component)) {
            return;
        }
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        ClientVersion version = user.getPacketVersion();
        if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            chatPacket = new WrapperPlayServerSystemChatMessage(false, component);
        } else {
            ChatType type = ChatTypes.CHAT;
            ChatMessage_v1_16 message = version.isNewerThanOrEquals(ClientVersion.V_1_16) ? new ChatMessage_v1_16(component, type, new UUID(0L, 0L)) : new ChatMessageLegacy(component, type);
            chatPacket = new WrapperPlayServerChatMessage((ChatMessage)message);
        }
        this.packetSender.send(fPlayer.getUuid(), (PacketWrapper<?>)chatPacket, silent);
    }

    public void sendTitle(FPlayer fPlayer, Component title, Component subTitle, Times times) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        user.sendTitle(title, subTitle, times.fadeInTicks(), times.stayTicks(), times.fadeOutTicks());
    }

    public void sendActionBar(FPlayer fPlayer, Component component) {
        this.sendActionBar(fPlayer, component, 0);
    }

    public void sendActionBar(FPlayer fPlayer, Component component, int stayTicks) {
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerSystemChatMessage(true, component));
        } else if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerActionBar(component));
        } else if (this.packetProvider.getServerVersion().isNewerThan(ServerVersion.V_1_16)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessage_v1_16(component, ChatTypes.GAME_INFO, fPlayer.getUuid())));
        } else if (this.packetProvider.getServerVersion().isNewerThan(ServerVersion.V_1_8_8)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessageLegacy(component, ChatTypes.GAME_INFO)));
        } else {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessageLegacy((Component)Component.text((String)LegacyComponentSerializer.legacySection().serialize(component)), ChatTypes.GAME_INFO)));
        }
        if (stayTicks <= 30) {
            return;
        }
        int remainingTicks = stayTicks - 30;
        int delay = Math.min(30, remainingTicks);
        this.taskScheduler.runAsyncLater(() -> this.sendActionBar(fPlayer, component, remainingTicks), delay);
    }

    public void sendPlayerListHeaderAndFooter(FPlayer fPlayer, Component header, Component footer) {
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerPlayerListHeaderAndFooter(header, footer));
    }

    public void sendBoosBar(FPlayer fPlayer, Component component, BossBar bossBar) {
        UUID bossBarUUID = UUID.randomUUID();
        WrapperPlayServerBossBar addWrapper = new WrapperPlayServerBossBar(bossBarUUID, WrapperPlayServerBossBar.Action.ADD);
        addWrapper.setTitle(component);
        addWrapper.setHealth(bossBar.getHealth());
        addWrapper.setOverlay(bossBar.getOverlay());
        addWrapper.setColor(bossBar.getColor());
        addWrapper.setFlags(bossBar.getFlags());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)addWrapper);
        this.taskScheduler.runAsyncLater(() -> {
            WrapperPlayServerBossBar removeWrapper = new WrapperPlayServerBossBar(bossBarUUID, WrapperPlayServerBossBar.Action.REMOVE);
            this.packetSender.send(fPlayer, (PacketWrapper<?>)removeWrapper);
        }, bossBar.getDuration());
    }

    public void sendBrand(FPlayer fPlayer, Component component) {
        String message = LegacyComponentSerializer.legacySection().serialize(component) + "\u00a7r";
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerPluginMessage("minecraft:brand", this.packetSerializer.serialize(message)));
    }

    public void sendToast(FPlayer fPlayer, Component title, Toast toast) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        ItemType itemType = ItemTypes.getByName((String)toast.icon());
        ItemStack itemStack = ItemStack.builder().type(itemType == null ? ItemTypes.DIAMOND : itemType).build();
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(title, (Component)Component.empty(), itemStack, AdvancementType.valueOf((String)toast.style().name()), null, true, false, 0.0f, 0.0f);
        String criterionName = "trigger";
        List<String> criteria = Collections.singletonList(criterionName);
        List<List<String>> requirements = Collections.singletonList(criteria);
        ResourceLocation advancementId = ResourceLocation.minecraft((String)UUID.randomUUID().toString());
        Advancement advancement = new Advancement(null, advancementDisplay, criteria, requirements, false);
        List<AdvancementHolder> advancementHolders = Collections.singletonList(new AdvancementHolder(advancementId, advancement));
        HashMap<String, AdvancementProgress.CriterionProgress> progressMap = new HashMap<String, AdvancementProgress.CriterionProgress>();
        progressMap.put(criterionName, new AdvancementProgress.CriterionProgress(Long.valueOf(System.currentTimeMillis())));
        AdvancementProgress progress = new AdvancementProgress(progressMap);
        WrapperPlayServerUpdateAdvancements showPacket = new WrapperPlayServerUpdateAdvancements(false, advancementHolders, Collections.emptySet(), Collections.singletonMap(advancementId, progress), true);
        user.sendPacket((PacketWrapper)showPacket);
        WrapperPlayServerUpdateAdvancements removePacket = new WrapperPlayServerUpdateAdvancements(false, Collections.emptyList(), Collections.singleton(advancementId), Collections.emptyMap(), false);
        user.sendPacket((PacketWrapper)removePacket);
    }

    @Inject
    @Generated
    public MessageSender(PacketSerializer packetSerializer, TaskScheduler taskScheduler, PacketSender packetSender, PacketProvider packetProvider, IntegrationModule integrationModule, FLogger fLogger) {
        this.packetSerializer = packetSerializer;
        this.taskScheduler = taskScheduler;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
        this.integrationModule = integrationModule;
        this.fLogger = fLogger;
    }
}

