/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.platform.proxy.Proxy;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.ProxyDataConsumer;
import net.flectone.pulse.util.SafeDataOutputStream;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class ProxySender {
    private final ProxyRegistry proxyRegistry;
    private final FileResolver fileResolver;
    private final MessagePipeline messagePipeline;
    private final Gson gson;
    private final FLogger fLogger;

    public boolean send(MessageType messageType, EventMetadata<?> eventMetadata) {
        ProxyDataConsumer<SafeDataOutputStream> proxyConsumer = eventMetadata.getProxy();
        if (proxyConsumer == null) {
            return false;
        }
        Range range = eventMetadata.getRange();
        if (!range.is(Range.Type.PROXY)) {
            return false;
        }
        FEntity sender = eventMetadata.getSender();
        return this.send(sender, messageType, proxyConsumer, eventMetadata.getUuid());
    }

    public boolean send(FEntity sender, MessageType tag) {
        return this.send(sender, tag, dataOutputStream -> {}, UUID.randomUUID());
    }

    public boolean send(FEntity sender, MessageType tag, ProxyDataConsumer<SafeDataOutputStream> outputConsumer, UUID metadataUUID) {
        byte[] message;
        boolean isPlayer = sender instanceof FPlayer;
        if (isPlayer) {
            FPlayer fPlayer = (FPlayer)sender;
            String constantName = this.getConstantName(fPlayer);
            fPlayer.setConstantName(constantName);
        }
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             SafeDataOutputStream output = new SafeDataOutputStream(this.gson, byteStream);){
            output.writeUTF(tag.toProxyTag());
            output.writeUTF(metadataUUID.toString());
            output.writeAsJson(this.fileResolver.getConfig().getProxy().getClusters());
            output.writeAsJson(sender);
            outputConsumer.accept(output);
            message = byteStream.toByteArray();
        }
        catch (IOException e) {
            this.fLogger.warning(e);
            return false;
        }
        boolean sent = false;
        for (Proxy proxy : this.proxyRegistry.getProxies()) {
            if (!proxy.sendMessage(sender, tag, message)) continue;
            sent = true;
        }
        return sent;
    }

    private String getConstantName(FPlayer sender) {
        String message = this.fileResolver.getLocalization(sender).getMessage().getFormat().getNames().getConstant();
        if (message.isEmpty()) {
            return "";
        }
        return this.messagePipeline.builder(sender, message).defaultSerializerBuild();
    }

    @Inject
    @Generated
    public ProxySender(ProxyRegistry proxyRegistry, FileResolver fileResolver, MessagePipeline messagePipeline, Gson gson, FLogger fLogger) {
        this.proxyRegistry = proxyRegistry;
        this.fileResolver = fileResolver;
        this.messagePipeline = messagePipeline;
        this.gson = gson;
        this.fLogger = fLogger;
    }
}

