/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.integer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.context.CommandInput;
import net.flectone.pulse.library.cloud.cloud.parser.ArgumentParseResult;
import net.flectone.pulse.library.cloud.cloud.parser.ArgumentParser;
import net.flectone.pulse.library.cloud.cloud.parser.standard.StringParser;
import net.flectone.pulse.library.cloud.cloud.suggestion.BlockingSuggestionProvider;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.processing.converter.ColorConverter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;

@Singleton
public class ColorParser
implements ArgumentParser<FPlayer, String>,
BlockingSuggestionProvider.Strings<FPlayer> {
    private static final List<String> HEX_SYMBOLS = List.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f");
    private final StringParser<FPlayer> stringParser = new StringParser(StringParser.StringMode.SINGLE);
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;

    @NonNull
    public ArgumentParseResult<String> parse(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.stringParser.parse(context, input);
    }

    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        ArrayList<String> suggestions;
        block7: {
            String current;
            block8: {
                block6: {
                    if (context == null) {
                        throw new NullPointerException("context is marked non-null but is null");
                    }
                    if (input == null) {
                        throw new NullPointerException("input is marked non-null but is null");
                    }
                    String currentInput = input.input();
                    String[] args = (currentInput = currentInput.substring(currentInput.indexOf(" ") + 1)).split(" ");
                    current = args.length == 0 || currentInput.endsWith(" ") ? "" : args[args.length - 1];
                    int maxColors = this.fileResolver.getMessage().getFormat().getFcolor().getDefaultColors().size();
                    boolean hasOtherPermission = this.permissionChecker.check((FEntity)context.sender(), this.fileResolver.getPermission().getCommand().getChatcolor().getOther());
                    if (!hasOtherPermission && args.length >= maxColors || hasOtherPermission && args.length >= maxColors + 1) {
                        return Collections.emptyList();
                    }
                    suggestions = new ArrayList<String>();
                    List<String> constants = List.of("clear", "<gradient:#", "<", "#", "&");
                    for (String constant : constants) {
                        if (!current.isEmpty() && !constant.startsWith(current)) continue;
                        suggestions.add(constant);
                    }
                    if (!current.startsWith("#") || current.length() >= 7) break block6;
                    for (String symbol : HEX_SYMBOLS) {
                        suggestions.add(current + symbol);
                    }
                    break block7;
                }
                if (!current.startsWith("&") || current.length() != 1) break block8;
                suggestions.addAll(ColorConverter.LEGACY_COLORS);
                break block7;
            }
            if (current.isEmpty()) break block7;
            for (String color : ColorConverter.NAMED_COLORS) {
                if (!color.startsWith(current)) continue;
                suggestions.add(color);
            }
        }
        return suggestions;
    }

    @Inject
    @Generated
    public ColorParser(FileResolver fileResolver, PermissionChecker permissionChecker) {
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
    }
}

