/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.moderation;

import lombok.NonNull;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.context.CommandInput;
import net.flectone.pulse.library.cloud.cloud.parser.ArgumentParseResult;
import net.flectone.pulse.library.cloud.cloud.parser.ArgumentParser;
import net.flectone.pulse.library.cloud.cloud.parser.standard.StringParser;
import net.flectone.pulse.library.cloud.cloud.suggestion.BlockingSuggestionProvider;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.service.ModerationService;

public abstract class ModerationParser
implements ArgumentParser<FPlayer, String>,
BlockingSuggestionProvider.Strings<FPlayer> {
    private final Moderation.Type type;
    private final ModerationService moderationService;
    private final StringParser<FPlayer> stringParser;

    protected ModerationParser(Moderation.Type type, ModerationService moderationService) {
        this.type = type;
        this.moderationService = moderationService;
        this.stringParser = new StringParser(StringParser.StringMode.SINGLE);
    }

    @NonNull
    public ArgumentParseResult<String> parse(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.stringParser.parse(context, input);
    }

    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.moderationService.getValidNames(this.type);
    }
}

