/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.player;

import lombok.NonNull;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.context.CommandInput;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.processing.parser.player.PlayerParser;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class OfflinePlayerParser
extends PlayerParser {
    private final FPlayerService playerService;

    @Inject
    public OfflinePlayerParser(FPlayerService playerService, IntegrationModule integrationModule) {
        super(playerService, integrationModule);
        this.playerService = playerService;
    }

    @Override
    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.playerService.findAllFPlayers().stream().filter(player -> !player.isUnknown()).map(FEntity::getName).toList();
    }
}

