/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.util.constant.MessageType;

public final class ProxyMessageProcessor {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] create(MessageType tag, UUID uuid) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream output = new DataOutputStream(byteStream);){
                output.writeUTF(tag.toProxyTag());
                output.writeUTF(uuid.toString());
                byArray = byteStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create message", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] create(byte[] data) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);){
            DataInputStream input;
            block17: {
                String tag;
                block16: {
                    byte[] byArray;
                    input = new DataInputStream(byteStream);
                    try {
                        tag = input.readUTF();
                        if (tag.startsWith("FlectonePulse")) break block16;
                        byArray = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    input.close();
                    return byArray;
                }
                MessageType proxyMessageType = MessageType.fromProxyString(tag);
                if (proxyMessageType != null) break block17;
                byte[] byArray = null;
                input.close();
                return byArray;
            }
            byte[] byArray = data;
            input.close();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process message", e);
        }
    }

    @Generated
    private ProxyMessageProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

