/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.processor;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.config.YamlFile;
import net.flectone.pulse.config.localization.EnglishLocale;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.config.localization.RussianLocale;
import net.flectone.pulse.exception.YamlReadException;
import net.flectone.pulse.exception.YamlWriteException;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.jackson.annotation.JsonProperty;
import net.flectone.pulse.library.jackson.annotation.JsonPropertyDescription;
import net.flectone.pulse.library.jackson.databind.ObjectMapper;
import net.flectone.pulse.library.jackson.databind.exc.MismatchedInputException;

@Singleton
public class YamlFileProcessor {
    private final String header = "#  ___       ___  __  ___  __        ___\n# |__  |    |__  /  `  |  /  \\ |\\ | |__\n# |    |___ |___ \\__,  |  \\__/ | \\| |___\n#  __             __   ___\n# |__) |  | |    /__` |__\n# |    \\__/ |___ .__/ |___   /\\\n#                           /  \\\n# __/\\___  ____/\\_____  ___/    \\______\n#        \\/           \\/\n#\n";
    private final ObjectMapper mapper;
    private final EnglishLocale englishLocale;
    private final RussianLocale russianLocale;

    public <T extends YamlFile> void reload(T yamlFile) throws IOException {
        if (yamlFile instanceof Localization) {
            Localization localization = (Localization)yamlFile;
            this.initLocalization(localization);
        }
        this.load(yamlFile);
        this.save(yamlFile);
    }

    public void initLocalization(Localization localization) {
        if (!localization.isInitialized()) {
            if (localization.getLanguage().equals("ru_ru")) {
                this.russianLocale.init(localization);
            } else {
                this.englishLocale.init(localization);
            }
            localization.setInitialized(true);
        }
    }

    public <T extends YamlFile> void load(T yamlFile) throws IOException {
        if (Files.exists(yamlFile.getPathToFile(), new LinkOption[0])) {
            File file = yamlFile.getPathToFile().toFile();
            try {
                this.mapper.readerForUpdating(yamlFile).readValue(file);
            }
            catch (Exception e) {
                MismatchedInputException mismatchedInputException;
                if (e instanceof MismatchedInputException && (mismatchedInputException = (MismatchedInputException)e).getMessage() != null && mismatchedInputException.getMessage().contains("No content to map due to end-of-input")) {
                    this.save(yamlFile);
                    return;
                }
                throw new YamlReadException(file.getName(), e);
            }
        }
    }

    public <T extends YamlFile> void save(T yamlFile) throws IOException {
        Localization localization;
        LinkedHashMap<String, String> comments = new LinkedHashMap<String, String>();
        boolean english = yamlFile instanceof Localization && !(localization = (Localization)yamlFile).getLanguage().equals("ru_ru");
        this.collectDescriptions(yamlFile.getClass(), "", comments, new HashSet(), english);
        Path pathToFile = yamlFile.getPathToFile();
        try {
            String yaml = this.mapper.writeValueAsString(yamlFile);
            String yamlWithComments = "#  ___       ___  __  ___  __        ___\n# |__  |    |__  /  `  |  /  \\ |\\ | |__\n# |    |___ |___ \\__,  |  \\__/ | \\| |___\n#  __             __   ___\n# |__) |  | |    /__` |__\n# |    \\__/ |___ .__/ |___   /\\\n#                           /  \\\n# __/\\___  ____/\\_____  ___/    \\______\n#        \\/           \\/\n#\n" + this.addCommentsToYaml(yaml, comments);
            Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
            Files.writeString(pathToFile, (CharSequence)yamlWithComments, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new YamlWriteException(pathToFile.toFile().getName(), e);
        }
    }

    private void collectDescriptions(Class<?> clazz, String basePath, Map<String, String> out, Set<Class<?>> visited, boolean english) {
        if (clazz == null || visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> classField;
            if (Modifier.isStatic(field.getModifiers())) continue;
            String propName = field.getName();
            JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
            if (jsonProperty != null && jsonProperty.value() != null && !jsonProperty.value().isEmpty()) {
                propName = jsonProperty.value();
            }
            String path = basePath.isEmpty() ? propName : basePath + "." + propName;
            JsonPropertyDescription propertyDescription = field.getAnnotation(JsonPropertyDescription.class);
            if (propertyDescription != null && propertyDescription.value() != null && !propertyDescription.value().isEmpty()) {
                String comment = propertyDescription.value().trim();
                if (english) {
                    comment = Strings.CS.replace(comment, "https://flectone.net/pulse/", "https://flectone.net/en/pulse/");
                }
                out.put(path, comment);
            }
            if (!this.isUserType(classField = field.getType())) continue;
            this.collectDescriptions(classField, path, out, visited, english);
        }
    }

    private boolean isUserType(Class<?> t) {
        if (t.isPrimitive()) {
            return false;
        }
        if (t.isEnum()) {
            return false;
        }
        if (t.getName().startsWith("java.")) {
            return false;
        }
        if (Collection.class.isAssignableFrom(t)) {
            return false;
        }
        if (Map.class.isAssignableFrom(t)) {
            return false;
        }
        return !t.isArray();
    }

    private String addCommentsToYaml(String yaml, Map<String, String> comments) {
        String[] lines = yaml.split("\n", -1);
        ArrayList<Object> out = new ArrayList<Object>(lines.length * 2);
        int indentUnit = this.detectIndentUnit(lines);
        if (indentUnit <= 0) {
            indentUnit = 2;
        }
        HashMap<Integer, String> pathAtDepth = new HashMap<Integer, String>();
        HashSet<String> alreadyInserted = new HashSet<String>();
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                out.add(line);
                continue;
            }
            if (trimmed.charAt(0) == '-') {
                out.add(line);
                continue;
            }
            int leading = this.countLeadingSpaces(line);
            String withoutLeading = line.substring(leading);
            int colonIndex = withoutLeading.indexOf(58);
            if (colonIndex == -1) {
                out.add(line);
                continue;
            }
            String keyPart = withoutLeading.substring(0, colonIndex).trim();
            if ((keyPart.startsWith("\"") && keyPart.endsWith("\"") || keyPart.startsWith("'") && keyPart.endsWith("'")) && keyPart.length() >= 2) {
                keyPart = keyPart.substring(1, keyPart.length() - 1);
            }
            int depth = Math.max(0, leading / indentUnit);
            pathAtDepth.put(depth, keyPart);
            pathAtDepth.keySet().removeIf(d -> d > depth);
            ArrayList<String> parts = new ArrayList<String>();
            for (int d2 = 0; d2 <= depth; ++d2) {
                String p = (String)pathAtDepth.get(d2);
                if (p == null || p.isEmpty()) continue;
                parts.add(p);
            }
            String path = String.join((CharSequence)".", parts);
            if (comments.containsKey(path) && !alreadyInserted.contains(path)) {
                String comment = comments.get(path);
                for (String cLine : comment.split("\n")) {
                    out.add(this.repeat(' ', leading) + "# " + cLine.trim());
                }
                alreadyInserted.add(path);
            }
            out.add(line);
        }
        return String.join((CharSequence)"\n", out);
    }

    private int detectIndentUnit(String[] lines) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String line : lines) {
            int leading;
            String trimmed = line.trim();
            if (trimmed.isEmpty() || !trimmed.contains(":") || (leading = this.countLeadingSpaces(line)) <= 0) continue;
            numbers.add(leading);
        }
        if (numbers.isEmpty()) {
            return -1;
        }
        int g = (Integer)J_U_List.getFirst(numbers);
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            g = this.gcd(g, n);
        }
        return g;
    }

    private int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return this.gcd(b, a % b);
    }

    private int countLeadingSpaces(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] arr = new char[n];
        Arrays.fill(arr, c);
        return new String(arr);
    }

    @Inject
    @Generated
    public YamlFileProcessor(ObjectMapper mapper, EnglishLocale englishLocale, RussianLocale russianLocale) {
        this.mapper = mapper;
        this.englishLocale = englishLocale;
        this.russianLocale = russianLocale;
    }
}

