/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.data.repository.FPlayerRepository;
import net.flectone.pulse.data.repository.SocialRepository;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import net.flectone.pulse.module.command.mail.model.Mail;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class FPlayerService {
    private final FileResolver fileResolver;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final FPlayerRepository fPlayerRepository;
    private final SocialRepository socialRepository;
    private final ModerationService moderationService;
    private final IntegrationModule integrationModule;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;

    public void clear() {
        this.fPlayerRepository.clearCache();
    }

    public void reload() {
        this.clear();
        this.addConsole();
        this.platformPlayerAdapter.getOnlinePlayers().forEach(uuid -> {
            String name = this.platformPlayerAdapter.getName((UUID)uuid);
            FPlayer fPlayer = this.addFPlayer((UUID)uuid, name);
            this.loadData(fPlayer);
            this.saveFPlayerData(fPlayer);
        });
    }

    public void addConsole() {
        FPlayer console = new FPlayer(true, this.fileResolver.getConfig().getLogger().getConsole());
        this.fPlayerRepository.add(console);
        this.fPlayerRepository.saveOrIgnore(console);
    }

    public FPlayer addFPlayer(UUID uuid, String name) {
        this.fPlayerRepository.save(uuid, name);
        this.moderationService.invalidate(uuid);
        FPlayer fPlayer = this.fPlayerRepository.get(uuid);
        if (fPlayer.isUnknown() || !fPlayer.getUuid().equals(uuid) || !fPlayer.getName().equals(name)) {
            this.fPlayerRepository.invalid(uuid);
            fPlayer = this.fPlayerRepository.get(uuid);
        }
        fPlayer.setIp(this.platformPlayerAdapter.getIp(fPlayer));
        fPlayer.setOnline(true);
        this.fPlayerRepository.add(fPlayer);
        return fPlayer;
    }

    public void loadData(FPlayer fPlayer) {
        this.loadSettings(fPlayer);
        this.loadColors(fPlayer);
        this.loadIgnores(fPlayer);
    }

    @Async
    public void saveFPlayerData(FPlayer fPlayer) {
        if (!this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        this.updateFPlayer(fPlayer);
    }

    public int getPing(FPlayer player) {
        Object platformPlayer = this.platformPlayerAdapter.convertToPlatformPlayer(player);
        if (platformPlayer == null) {
            return 0;
        }
        return this.packetProvider.getPing(platformPlayer);
    }

    public String getSortedName(FPlayer fPlayer) {
        int weight = this.integrationModule.getGroupWeight(fPlayer);
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            String paddedRank = String.format("%010d", Integer.MAX_VALUE - weight);
            String paddedName = String.format("%-16s", fPlayer.getName());
            return paddedRank + paddedName;
        }
        String paddedRank = String.format("%06d", Integer.MAX_VALUE - weight);
        String truncatedName = fPlayer.getName().substring(0, Math.min(fPlayer.getName().length(), 10));
        String paddedName = String.format("%-10s", truncatedName);
        return paddedRank + paddedName;
    }

    public void invalidateOffline(UUID uuid) {
        this.fPlayerRepository.removeOffline(uuid);
    }

    public void invalidateOnline(UUID uuid) {
        this.fPlayerRepository.removeOnline(uuid);
    }

    public void clearAndSave(FPlayer fPlayer) {
        fPlayer.setOnline(false);
        fPlayer.setIp(this.platformPlayerAdapter.getIp(fPlayer));
        this.invalidateOnline(fPlayer.getUuid());
        this.updateFPlayer(fPlayer);
    }

    public void updateFPlayer(FPlayer fPlayer) {
        this.fPlayerRepository.update(fPlayer);
    }

    public int getEntityId(FPlayer fPlayer) {
        return this.platformPlayerAdapter.getEntityId(fPlayer.getUuid());
    }

    public FPlayer getFPlayer(int id) {
        return this.fPlayerRepository.get(id);
    }

    public FPlayer getFPlayer(String name) {
        return this.fPlayerRepository.get(name);
    }

    public FPlayer getFPlayer(InetAddress inetAddress) {
        return this.fPlayerRepository.get(inetAddress);
    }

    public FPlayer getFPlayer(UUID uuid) {
        return this.fPlayerRepository.get(uuid);
    }

    public FPlayer getFPlayer(Object player) {
        String name = this.platformPlayerAdapter.getName(player);
        if (name.isEmpty()) {
            return FPlayer.UNKNOWN;
        }
        UUID uuid = this.platformPlayerAdapter.getUUID(player);
        if (uuid == null) {
            if (this.platformPlayerAdapter.isConsole(player)) {
                return this.getFPlayer(-1);
            }
            return new FPlayer(name);
        }
        FPlayer fPlayer = this.getFPlayer(uuid);
        if (fPlayer.isUnknown()) {
            return new FPlayer(name, uuid, this.platformPlayerAdapter.getEntityTranslationKey(player));
        }
        return fPlayer;
    }

    public Object toPlatformFPlayer(FPlayer fPlayer) {
        return this.platformPlayerAdapter.convertToPlatformPlayer(fPlayer);
    }

    public List<FPlayer> findAllFPlayers() {
        return this.fPlayerRepository.getAllPlayersDatabase();
    }

    public List<FPlayer> findOnlineFPlayers() {
        return this.fPlayerRepository.getOnlinePlayersDatabase();
    }

    public List<FPlayer> getOnlineFPlayers() {
        return this.fPlayerRepository.getOnlinePlayers();
    }

    public List<FPlayer> getVisibleFPlayersFor(FPlayer fViewer) {
        return this.getOnlineFPlayers().stream().filter(target -> this.integrationModule.canSeeVanished((FEntity)target, fViewer)).toList();
    }

    public List<FPlayer> getFPlayersWhoCanSee(FPlayer target) {
        return this.getOnlineFPlayers().stream().filter(viewer -> this.integrationModule.canSeeVanished(target, (FEntity)viewer)).toList();
    }

    public List<FPlayer> getPlatformFPlayers() {
        return this.fPlayerRepository.getOnlinePlayers().stream().filter(this.platformPlayerAdapter::isOnline).toList();
    }

    public List<FPlayer> getFPlayersWithConsole() {
        return this.fPlayerRepository.getOnlineFPlayersWithConsole();
    }

    public void kick(FPlayer fPlayer, Component reason) {
        WrapperPlayServerDisconnect packet = new WrapperPlayServerDisconnect(reason);
        this.packetSender.send(fPlayer, (PacketWrapper<?>)packet);
    }

    public void loadColors(FPlayer fPlayer) {
        this.fPlayerRepository.loadColors(fPlayer);
    }

    public void saveColors(FPlayer fPlayer) {
        this.fPlayerRepository.saveColors(fPlayer);
    }

    public void loadIgnoresIfOffline(FPlayer fPlayer) {
        if (this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        this.loadIgnores(fPlayer);
    }

    public void loadIgnores(FPlayer fPlayer) {
        this.socialRepository.loadIgnores(fPlayer);
    }

    public void loadSettingsIfOffline(FPlayer fPlayer) {
        if (this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        this.loadSettings(fPlayer);
    }

    public void loadSettings(FPlayer fPlayer) {
        this.fPlayerRepository.loadSettings(fPlayer);
    }

    public List<Mail> getReceiverMails(FPlayer fPlayer) {
        return this.socialRepository.getReceiverMails(fPlayer);
    }

    public List<Mail> getSenderMails(FPlayer fPlayer) {
        return this.socialRepository.getSenderMails(fPlayer);
    }

    public Ignore saveAndGetIgnore(FPlayer fPlayer, FPlayer fTarget) {
        return this.socialRepository.saveAndGetIgnore(fPlayer, fTarget);
    }

    public Mail saveAndGetMail(FPlayer fPlayer, FPlayer fTarget, String message) {
        return this.socialRepository.saveAndGetMail(fPlayer, fTarget, message);
    }

    public void deleteIgnore(Ignore ignore) {
        this.socialRepository.deleteIgnore(ignore);
    }

    public void deleteMail(Mail mail) {
        this.socialRepository.deleteMail(mail);
    }

    public void saveSettings(FPlayer fPlayer) {
        this.fPlayerRepository.saveSettings(fPlayer);
    }

    public void saveOrUpdateSetting(FPlayer fPlayer, String setting) {
        this.fPlayerRepository.saveOrUpdateSetting(fPlayer, setting);
    }

    public void saveOrUpdateSetting(FPlayer fPlayer, SettingText setting) {
        this.fPlayerRepository.saveOrUpdateSetting(fPlayer, setting);
    }

    @Async(delay=40L)
    public void updateLocaleLater(UUID uuid, String wrapperLocale) {
        FPlayer fPlayer = this.getFPlayer(uuid);
        this.updateLocale(fPlayer, wrapperLocale);
    }

    public void updateLocale(FPlayer fPlayer, String newLocale) {
        String locale = this.integrationModule.getTritonLocale(fPlayer);
        if (locale == null) {
            locale = newLocale;
        }
        if (locale.equals(fPlayer.getSetting(SettingText.LOCALE))) {
            return;
        }
        if (fPlayer.isUnknown()) {
            return;
        }
        fPlayer.setSetting(SettingText.LOCALE, locale);
        this.saveOrUpdateSetting(fPlayer, SettingText.LOCALE);
    }

    @Inject
    @Generated
    public FPlayerService(FileResolver fileResolver, PlatformPlayerAdapter platformPlayerAdapter, FPlayerRepository fPlayerRepository, SocialRepository socialRepository, ModerationService moderationService, IntegrationModule integrationModule, PacketSender packetSender, PacketProvider packetProvider) {
        this.fileResolver = fileResolver;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.fPlayerRepository = fPlayerRepository;
        this.socialRepository = socialRepository;
        this.moderationService = moderationService;
        this.integrationModule = integrationModule;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
    }
}

