/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.creator;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.YamlFile;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.jetbrains.annotations.Nullable;

@Singleton
public class BackupCreator {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final SystemVariableResolver systemVariableResolver;
    @Named(value="projectPath")
    private final Path projectPath;
    @Named(value="backupPath")
    private final Path backupPath;
    private final FLogger fLogger;
    @Nullable
    private String preInitVersion;

    public <T extends YamlFile> void backup(T yamlFile) {
        if (this.preInitVersion == null) {
            this.fLogger.warning("Backup is not needed if the version has not changed");
            return;
        }
        String fileName = yamlFile.getPathToFile().getFileName().toString();
        this.backup(fileName, yamlFile.getPathToFile());
    }

    public void backup(Config.Database database) {
        if (this.preInitVersion == null) {
            this.fLogger.warning("Backup is not needed if the version has not changed");
            return;
        }
        Database.Type databaseType = database.getType();
        Object databaseName = this.systemVariableResolver.substituteEnvVars(database.getName());
        switch (databaseType) {
            case SQLITE: 
            case H2: {
                databaseName = (String)databaseName + (databaseType == Database.Type.SQLITE ? ".db" : ".h2.mv.db");
                this.backup((String)databaseName, this.projectPath.resolve((String)databaseName));
                break;
            }
            case MYSQL: 
            case MARIADB: 
            case POSTGRESQL: {
                try {
                    ProcessBuilder processBuilder;
                    String backupFileName = (String)databaseName + "_" + SIMPLE_DATE_FORMAT.format(new Date()) + ".sql";
                    Path backupPath = this.resolveBackupPath(backupFileName);
                    String host = this.systemVariableResolver.substituteEnvVars(database.getHost());
                    String port = this.systemVariableResolver.substituteEnvVars(database.getPort());
                    String user = this.systemVariableResolver.substituteEnvVars(database.getUser());
                    String password = this.systemVariableResolver.substituteEnvVars(database.getPassword());
                    HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                    if (databaseType == Database.Type.MYSQL || databaseType == Database.Type.MARIADB) {
                        env.put("MYSQL_PWD", password);
                        processBuilder = new ProcessBuilder(new String[]{this.getMySQLDumpCommand(), "-h", host, "-P", port, "-u", user, "--ssl=0", "--ssl-verify-server-cert=0", "--single-transaction", "--routines", "--triggers", "--events", databaseName});
                    } else {
                        env.put("PGPASSWORD", password);
                        processBuilder = new ProcessBuilder(new String[]{"pg_dump", "-h", host, "-p", port, "-U", user, "-d", databaseName, "-w"});
                    }
                    processBuilder.redirectOutput(backupPath.toFile());
                    processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                    processBuilder.environment().putAll(env);
                    Process process = processBuilder.start();
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    this.fLogger.warning(String.valueOf((Object)databaseType) + " backup failed (exit code: " + exitCode + ")");
                    break;
                }
                catch (IOException | InterruptedException e) {
                    this.fLogger.warning("Failed to backup " + String.valueOf((Object)databaseType) + ": " + e.getMessage());
                }
            }
        }
    }

    private String getMySQLDumpCommand() {
        if (this.isCommandAvailable("mariadb-dump")) {
            return "mariadb-dump";
        }
        return "mysqldump";
    }

    private boolean isCommandAvailable(String command) {
        try {
            Process process = new ProcessBuilder(command, "--version").start();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Path resolveBackupPath(String newFileName) {
        return this.backupPath.resolve(this.preInitVersion).resolve(newFileName);
    }

    private void backup(String fileName, Path pathToFile) {
        String newFileName = fileName + "_" + SIMPLE_DATE_FORMAT.format(new Date());
        Path backupFilePath = this.resolveBackupPath(newFileName);
        try {
            Files.createDirectories(backupFilePath.getParent(), new FileAttribute[0]);
            Files.copy(pathToFile, backupFilePath, new CopyOption[0]);
        }
        catch (IOException e) {
            this.fLogger.warning("Failed to backup " + fileName, e);
        }
    }

    @Inject
    @Generated
    public BackupCreator(SystemVariableResolver systemVariableResolver, @Named(value="projectPath") Path projectPath, @Named(value="backupPath") Path backupPath, FLogger fLogger) {
        this.systemVariableResolver = systemVariableResolver;
        this.projectPath = projectPath;
        this.backupPath = backupPath;
        this.fLogger = fLogger;
    }

    @Generated
    public void setPreInitVersion(@Nullable String preInitVersion) {
        this.preInitVersion = preInitVersion;
    }
}

