/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.interceptor;

import java.lang.reflect.Method;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.scheduler.SchedulerRunnable;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.util.logging.FLogger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
public class AsyncInterceptor
implements MethodInterceptor {
    private final Provider<TaskScheduler> taskScheduler;
    private final Provider<PlatformServerAdapter> platformServerAdapter;
    private final FLogger fLogger;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isAnnotationPresent(Async.class)) {
            return invocation.proceed();
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalStateException("@Async can only be applied to void methods");
        }
        Async async = method.getAnnotation(Async.class);
        long delay = async.delay();
        boolean independent = async.independent();
        SchedulerRunnable task = () -> this.proceedSafely(invocation);
        if (delay > 0L) {
            ((TaskScheduler)this.taskScheduler.get()).runAsyncLater(task, delay);
        } else if (independent || ((PlatformServerAdapter)this.platformServerAdapter.get()).isPrimaryThread() || this.isRestrictedAsyncThread()) {
            ((TaskScheduler)this.taskScheduler.get()).runAsync(task);
        } else {
            task.run();
        }
        return null;
    }

    private boolean isRestrictedAsyncThread() {
        String threadName = Thread.currentThread().getName();
        return threadName.startsWith("Netty") || threadName.startsWith("Async Chat");
    }

    private void proceedSafely(MethodInvocation invocation) {
        try {
            invocation.proceed();
        }
        catch (Throwable e) {
            this.fLogger.warning(e);
        }
    }

    @Inject
    @Generated
    public AsyncInterceptor(Provider<TaskScheduler> taskScheduler, Provider<PlatformServerAdapter> platformServerAdapter, FLogger fLogger) {
        this.taskScheduler = taskScheduler;
        this.platformServerAdapter = platformServerAdapter;
        this.fLogger = fLogger;
    }
}

