/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.interceptor;

import java.lang.reflect.Method;
import lombok.Generated;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.execution.scheduler.SchedulerRunnable;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.util.logging.FLogger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
public class SyncInterceptor
implements MethodInterceptor {
    private final Provider<TaskScheduler> taskScheduler;
    private final Provider<PlatformServerAdapter> platformServerAdapter;
    private final FLogger fLogger;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isAnnotationPresent(Sync.class)) {
            return invocation.proceed();
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalStateException("@Sync can only be applied to void methods");
        }
        long delay = method.getAnnotation(Sync.class).delay();
        SchedulerRunnable task = () -> this.proceedSafely(invocation);
        if (delay > 0L) {
            ((TaskScheduler)this.taskScheduler.get()).runSyncLater(task, delay);
        } else if (((PlatformServerAdapter)this.platformServerAdapter.get()).isPrimaryThread()) {
            task.run();
        } else {
            ((TaskScheduler)this.taskScheduler.get()).runSync(task);
        }
        return null;
    }

    private void proceedSafely(MethodInvocation invocation) {
        try {
            invocation.proceed();
        }
        catch (Throwable e) {
            this.fLogger.warning(e);
        }
    }

    @Inject
    @Generated
    public SyncInterceptor(Provider<TaskScheduler> taskScheduler, Provider<PlatformServerAdapter> platformServerAdapter, FLogger fLogger) {
        this.taskScheduler = taskScheduler;
        this.platformServerAdapter = platformServerAdapter;
        this.fLogger = fLogger;
    }
}

