/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import com.github.retrooper.packetevents.PacketEvents;
import lombok.Generated;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.exception.ReloadException;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.platform.controller.DialogController;
import net.flectone.pulse.platform.controller.InventoryController;
import net.flectone.pulse.platform.controller.ModuleController;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.registry.PermissionRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.MetricsService;
import net.flectone.pulse.service.MinecraftTranslationService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class FlectonePulseAPI {
    private static FlectonePulse instance;

    @Inject
    public FlectonePulseAPI(FlectonePulse instance) {
        FlectonePulseAPI.instance = instance;
    }

    public void onEnable() {
        if (!instance.isReady()) {
            return;
        }
        FLogger fLogger = instance.get(FLogger.class);
        FileResolver fileResolver = instance.get(FileResolver.class);
        fLogger.setFileResolver(fileResolver);
        fLogger.logDescription();
        instance.get(MinecraftTranslationService.class).reload();
        instance.get(ListenerRegistry.class).registerDefaultListeners();
        fLogger.setupFilter();
        try {
            instance.get(Database.class).connect();
        }
        catch (Exception e) {
            fLogger.warning(e);
        }
        PacketEvents.getAPI().init();
        instance.get(ModuleController.class).reload();
        instance.get(FPlayerService.class).reload();
        instance.get(ProxyRegistry.class).onEnable();
        if (fileResolver.getConfig().getMetrics().isEnable()) {
            instance.get(MetricsService.class).reload();
        }
        fLogger.logEnabled();
    }

    public void onDisable() {
        if (!instance.isReady()) {
            PacketEvents.getAPI().terminate();
            return;
        }
        FLogger fLogger = instance.get(FLogger.class);
        fLogger.logDisabling();
        instance.get(TaskScheduler.class).shutdown();
        if (instance.get(FileResolver.class).getConfig().getMetrics().isEnable()) {
            instance.get(MetricsService.class).send();
        }
        instance.get(InventoryController.class).closeAll();
        instance.get(DialogController.class).closeAll();
        FPlayerService fPlayerService = instance.get(FPlayerService.class);
        fPlayerService.getOnlineFPlayers().forEach(fPlayer -> {
            fPlayer.setOnline(false);
            fPlayerService.updateFPlayer((FPlayer)fPlayer);
        });
        fPlayerService.clear();
        instance.get(ModuleController.class).terminate();
        instance.get(ListenerRegistry.class).unregisterAll();
        PacketEvents.getAPI().terminate();
        instance.get(ProxyRegistry.class).onDisable();
        instance.get(Database.class).disconnect();
        fLogger.logDisabled();
    }

    public void reload() throws ReloadException {
        if (!instance.isReady()) {
            return;
        }
        ReloadException reloadException = null;
        FLogger fLogger = instance.get(FLogger.class);
        fLogger.logReloading();
        FileResolver fileResolver = instance.get(FileResolver.class);
        try {
            fileResolver.reload();
        }
        catch (Exception e) {
            reloadException = new ReloadException(e.getMessage(), e);
        }
        instance.get(MinecraftTranslationService.class).reload();
        instance.get(InventoryController.class).closeAll();
        instance.get(DialogController.class).closeAll();
        instance.get(CommandRegistry.class).reload();
        instance.get(ListenerRegistry.class).reload();
        instance.get(PermissionRegistry.class).reload();
        instance.get(ProxyRegistry.class).reload();
        instance.get(TaskScheduler.class).reload();
        fLogger.setupFilter();
        FPlayerService fPlayerService = instance.get(FPlayerService.class);
        try {
            instance.get(Database.class).disconnect();
            instance.get(Database.class).connect();
            fPlayerService.reload();
        }
        catch (Exception e) {
            reloadException = new ReloadException(e.getMessage(), e);
        }
        instance.get(ModerationService.class).reload();
        instance.get(ModuleController.class).reload();
        EventDispatcher eventDispatcher = instance.get(EventDispatcher.class);
        fPlayerService.getPlatformFPlayers().forEach(fPlayer -> eventDispatcher.dispatch(new PlayerLoadEvent((FPlayer)fPlayer, true)));
        if (fileResolver.getConfig().getMetrics().isEnable()) {
            instance.get(MetricsService.class).reload();
        }
        fLogger.logReloaded();
        if (reloadException != null) {
            throw reloadException;
        }
    }

    @Generated
    public static FlectonePulse getInstance() {
        return instance;
    }
}

