/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.flectone.pulse.config.ModuleConfig;
import net.flectone.pulse.config.YamlFile;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.library.jackson.annotation.JsonMerge;
import net.flectone.pulse.library.jackson.annotation.JsonPropertyDescription;
import net.flectone.pulse.library.jackson.annotation.OptBoolean;
import net.flectone.pulse.util.constant.CacheName;

public final class Config
extends YamlFile {
    @JsonPropertyDescription(value=" Don't change it if you don't know what it is")
    private String version = "1.6.1";
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/language/")
    private Language language = new Language();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/database/")
    private Database database = new Database();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/proxy/")
    private Proxy proxy = new Proxy();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/command/")
    private Command command = new Command();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/module/")
    private Module module = new Module();
    @JsonPropertyDescription(value="https://flectone.net/pulse/docs/config/editor/")
    private Editor editor = new Editor();
    @JsonPropertyDescription(value="https://flectone.net/pulse/docs/config/logger/")
    private Logger logger = new Logger();
    @JsonPropertyDescription(value="https://flectone.net/pulse/docs/config/cache/")
    private Cache cache = new Cache();
    @JsonPropertyDescription(value="Help us improve FlectonePulse! This collects basic, anonymous data like server version and module usage. \nNo personal data, No IPs, No player names. \nThis helps us understand what features matter most and focus development where it's needed. \nYou can see the public stats here: https://flectone.net/pulse/metrics/ \nThanks for supporting the project! \u2764\ufe0f")
    private Metrics metrics = new Metrics();

    public Config(Path projectPath) {
        super(projectPath.resolve("config.yml"));
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Generated
    public Module getModule() {
        return this.module;
    }

    @Generated
    public Editor getEditor() {
        return this.editor;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    public static final class Language {
        private String type = "en_us";
        private boolean byPlayer = true;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isByPlayer() {
            return this.byPlayer;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }
    }

    public static final class Database {
        private Database.Type type = Database.Type.H2;
        private String name = "flectonepulse";
        private String host = "127.0.0.1";
        private String port = "3306";
        private String user = "root";
        private String password = "1234";
        private String parameters = "?autoReconnect=true&useSSL=false&useUnicode=true&characterEncoding=UTF-8";
        private String prefix = "";

        @Generated
        public Database.Type getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getParameters() {
            return this.parameters;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public void setType(Database.Type type) {
            this.type = type;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(String port) {
            this.port = port;
        }

        @Generated
        public void setUser(String user) {
            this.user = user;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Generated
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static final class Proxy {
        @JsonMerge(value=OptBoolean.FALSE)
        private Set<String> clusters = new HashSet<String>();
        private boolean bungeecord = false;
        private boolean velocity = false;
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/config/proxy#redis")
        private Redis redis = new Redis();

        @Generated
        public Set<String> getClusters() {
            return this.clusters;
        }

        @Generated
        public boolean isBungeecord() {
            return this.bungeecord;
        }

        @Generated
        public boolean isVelocity() {
            return this.velocity;
        }

        @Generated
        public Redis getRedis() {
            return this.redis;
        }

        public static final class Redis
        implements IEnable {
            private boolean enable = false;
            private String host = "127.0.0.1";
            private int port = 6379;
            private boolean ssl = false;
            private String user = "";
            private String password = "";

            @Override
            @Generated
            public boolean isEnable() {
                return this.enable;
            }

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public boolean isSsl() {
                return this.ssl;
            }

            @Generated
            public String getUser() {
                return this.user;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }
        }
    }

    public static final class Command {
        private boolean unregisterOnReload = false;
        @JsonMerge(value=OptBoolean.FALSE)
        private Set<String> disabledFabric = new HashSet<String>(Set.of("tell", "msg", "w", "me", "ban", "kick", "pardon", "banlist"));

        @Generated
        public boolean isUnregisterOnReload() {
            return this.unregisterOnReload;
        }

        @Generated
        public Set<String> getDisabledFabric() {
            return this.disabledFabric;
        }
    }

    public static final class Module
    implements ModuleConfig,
    IEnable {
        private boolean enable = true;

        @Override
        public ModuleConfig.CommandConfig getCommand() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig getIntegration() {
            return null;
        }

        @Override
        public ModuleConfig.MessageConfig getMessage() {
            return null;
        }

        @Override
        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static final class Editor {
        private String host = "";
        private boolean https = false;
        private int port = 25566;

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public boolean isHttps() {
            return this.https;
        }

        @Generated
        public int getPort() {
            return this.port;
        }
    }

    public static final class Logger {
        private String console = "Console";
        private String prefix = "\u001b[0;34m(FlectonePulse) \u001b[0m";
        @JsonMerge(value=OptBoolean.FALSE)
        private List<String> description = new ArrayList<String>(List.of(" \u001b[0;34m ___       ___  __  ___  __        ___ \u001b[0m", " \u001b[0;34m|__  |    |__  /  `  |  /  \\ |\\ | |__  \u001b[0m", " \u001b[0;34m|    |___ |___ \\__,  |  \\__/ | \\| |___ \u001b[0m", " \u001b[0;34m __             __   ___ \u001b[0;96m                       \u001b[0m", " \u001b[0;34m|__) |  | |    /__` |__  \u001b[0;96m                   \u001b[0m", " \u001b[0;34m|    \\__/ |___ .__/ |___\u001b[0;96m   /\\         \u001b[0m", " \u001b[0;96m                          /  \\ v<version>               \u001b[0m", " \u001b[0;96m__/\\___  ____/\\_____  ___/    \\______ \u001b[0m", " \u001b[0;96m       \\/           \\/  \u001b[0m"));
        private String warn = "\u001b[0;93m";
        private String info = "\u001b[0;96m";
        @JsonMerge(value=OptBoolean.FALSE)
        private List<String> filter = new ArrayList<String>(List.of("Paper Async Command Builder", "Caught previously unhandled exception :", "Error received from Telegram GetUpdates Request", "OkHttp TaskRunner", "Exception in thread \"ForkJoinPool", "FlectonePulseDatabase - "));

        @Generated
        public String getConsole() {
            return this.console;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public List<String> getDescription() {
            return this.description;
        }

        @Generated
        public String getWarn() {
            return this.warn;
        }

        @Generated
        public String getInfo() {
            return this.info;
        }

        @Generated
        public List<String> getFilter() {
            return this.filter;
        }
    }

    public static final class Cache {
        @JsonMerge(value=OptBoolean.FALSE)
        private Map<CacheName, CacheSetting> types = new EnumMap<CacheName, CacheSetting>(CacheName.class){
            {
                super(keyType);
                this.put(CacheName.DIALOG_CLICK, new CacheSetting(1L, TimeUnit.SECONDS, 100L));
                this.put(CacheName.OFFLINE_PLAYERS, new CacheSetting(1L, TimeUnit.HOURS, 1000L));
                this.put(CacheName.MODERATION, new CacheSetting(1L, TimeUnit.HOURS, 5000L));
                this.put(CacheName.LEGACY_COLOR_MESSAGE, new CacheSetting(10L, TimeUnit.MINUTES, 100000L));
                this.put(CacheName.MENTION_MESSAGE, new CacheSetting(10L, TimeUnit.MINUTES, 1000L));
                this.put(CacheName.SWEAR_MESSAGE, new CacheSetting(10L, TimeUnit.MINUTES, 100000L));
                this.put(CacheName.REPLACEMENT_MESSAGE, new CacheSetting(10L, TimeUnit.MINUTES, 100000L));
                this.put(CacheName.REPLACEMENT_IMAGE, new CacheSetting(10L, TimeUnit.MINUTES, 100L));
                this.put(CacheName.TRANSLATE_MESSAGE, new CacheSetting(1L, TimeUnit.HOURS, 5000L));
                this.put(CacheName.PROFILE_PROPERTY, new CacheSetting(1L, TimeUnit.HOURS, 1000L));
            }
        };

        @Generated
        public Map<CacheName, CacheSetting> getTypes() {
            return this.types;
        }

        public static final class CacheSetting {
            private long duration = 1L;
            private TimeUnit timeUnit = TimeUnit.MINUTES;
            private long size = 100L;

            @Generated
            public long getDuration() {
                return this.duration;
            }

            @Generated
            public TimeUnit getTimeUnit() {
                return this.timeUnit;
            }

            @Generated
            public long getSize() {
                return this.size;
            }

            @Generated
            public CacheSetting(long duration, TimeUnit timeUnit, long size) {
                this.duration = duration;
                this.timeUnit = timeUnit;
                this.size = size;
            }

            @Generated
            public CacheSetting() {
            }
        }
    }

    public static final class Metrics {
        private boolean enable = true;

        @Generated
        public boolean isEnable() {
            return this.enable;
        }
    }

    public static interface IEnable {
        public boolean isEnable();
    }
}

