/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.IgnoreSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import org.jetbrains.annotations.Nullable;

@Singleton
public class IgnoreDAO
extends BaseDAO<IgnoreSQL> {
    private final Database database;

    @Override
    public Database database() {
        return this.database;
    }

    @Override
    public Class<IgnoreSQL> sqlClass() {
        return IgnoreSQL.class;
    }

    @Nullable
    public Ignore insert(FPlayer fSender, FPlayer fIgnored) {
        if (fSender.isUnknown() || fIgnored.isUnknown()) {
            return null;
        }
        return this.inTransaction(sql -> {
            long currentTime = System.currentTimeMillis();
            int updated = sql.update(currentTime, fSender.getId(), fIgnored.getId());
            if (updated == 0) {
                int insertedId = sql.insert(currentTime, fSender.getId(), fIgnored.getId());
                return new Ignore(insertedId, currentTime, fIgnored.getId());
            }
            return sql.findByInitiatorAndTarget(fSender.getId(), fIgnored.getId()).orElseThrow();
        });
    }

    public void invalidate(Ignore ignore) {
        this.useHandle(sql -> sql.invalidate(ignore.id()));
    }

    public void load(FPlayer fPlayer) {
        if (fPlayer.isUnknown()) {
            return;
        }
        List ignores = this.withHandle(sql -> sql.findByInitiator(fPlayer.getId()));
        fPlayer.getIgnores().addAll(ignores);
    }

    @Inject
    @Generated
    public IgnoreDAO(Database database) {
        this.database = database;
    }
}

