/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerDisconnect;
import com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSettings;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.processor.PlayerPreLoginProcessor;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class BasePacketListener
implements PacketListener {
    private final FPlayerService fPlayerService;
    private final EventDispatcher eventDispatcher;
    private final PacketProvider packetProvider;
    private final PacketSender packetSender;
    private final PlayerPreLoginProcessor playerPreLoginProcessor;
    private final FLogger fLogger;

    public void onPacketReceive(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType != PacketType.Play.Client.CLIENT_SETTINGS && packetType != PacketType.Configuration.Client.CLIENT_SETTINGS) {
            return;
        }
        UUID uuid = event.getUser().getUUID();
        if (uuid == null) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        WrapperPlayClientSettings wrapperPlayClientSettings = new WrapperPlayClientSettings(event);
        String wrapperLocale = wrapperPlayClientSettings.getLocale();
        this.fPlayerService.updateLocale(fPlayer, wrapperLocale);
        this.fPlayerService.updateLocaleLater(uuid, wrapperLocale);
    }

    public void onPacketSend(PacketSendEvent event) {
        TranslatableComponent translatableComponent;
        Optional<Pair<Component, Boolean>> optionalPair;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS && this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
            WrapperLoginServerLoginSuccess wrapper = new WrapperLoginServerLoginSuccess(event);
            UserProfile userProfile = wrapper.getUserProfile();
            UUID uuid = userProfile.getUUID();
            if (uuid == null) {
                return;
            }
            String playerName = userProfile.getName();
            if (playerName == null) {
                return;
            }
            event.setCancelled(true);
            this.playerPreLoginProcessor.processAsyncLogin(uuid, playerName, loginEvent -> this.packetSender.send(uuid, (PacketWrapper<?>)new WrapperLoginServerLoginSuccess(uuid, playerName)), loginEvent -> this.packetSender.send(uuid, (PacketWrapper<?>)new WrapperLoginServerDisconnect(loginEvent.getKickReason())));
        }
        if ((optionalPair = this.toMessageReceiveEvent(event)).isEmpty()) {
            return;
        }
        User user = event.getUser();
        if (user == null) {
            return;
        }
        UUID userUUID = user.getUUID();
        if (userUUID == null) {
            return;
        }
        Pair<Component, Boolean> triplet = optionalPair.get();
        Object object = triplet.first();
        if (object instanceof TranslatableComponent && (translatableComponent = (TranslatableComponent)object).key().equals("multiplayer.message_not_delivered")) {
            event.setCancelled(true);
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(userUUID);
        MessageReceiveEvent messageReceiveEvent = new MessageReceiveEvent(fPlayer, triplet);
        this.eventDispatcher.dispatch(messageReceiveEvent);
        event.setCancelled(messageReceiveEvent.isCancelled());
    }

    private Optional<Pair<Component, Boolean>> toMessageReceiveEvent(PacketSendEvent event) {
        Component component = null;
        boolean overlay = false;
        try {
            if (event.getPacketType() == PacketType.Play.Server.CHAT_MESSAGE) {
                WrapperPlayServerChatMessage wrapper = new WrapperPlayServerChatMessage(event);
                component = wrapper.getMessage().getChatContent();
            } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                WrapperPlayServerSystemChatMessage wrapper = new WrapperPlayServerSystemChatMessage(event);
                component = wrapper.getMessage();
                overlay = wrapper.isOverlay();
            }
        }
        catch (Exception e) {
            this.fLogger.warning("Error when reading a PacketType.Play.Server." + String.valueOf(event.getPacketType()) + ", THIS IS NOT A FLECTONEPULSE BUG, Report to PacketEvents: " + e.getMessage());
        }
        if (component != null) {
            return Optional.of(Pair.of((Object)component, (Object)overlay));
        }
        return Optional.empty();
    }

    @Inject
    @Generated
    public BasePacketListener(FPlayerService fPlayerService, EventDispatcher eventDispatcher, PacketProvider packetProvider, PacketSender packetSender, PlayerPreLoginProcessor playerPreLoginProcessor, FLogger fLogger) {
        this.fPlayerService = fPlayerService;
        this.eventDispatcher = eventDispatcher;
        this.packetProvider = packetProvider;
        this.packetSender = packetSender;
        this.playerPreLoginProcessor = playerPreLoginProcessor;
        this.fLogger = fLogger;
    }
}

