/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.util;

import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.library.jackson.annotation.JsonCreator;
import net.flectone.pulse.library.jackson.annotation.JsonValue;

public class Sound {
    private final boolean enable;
    private final float volume;
    private final float pitch;
    private final String category;
    private final String name;
    private String permission = "";

    public Sound(boolean enable, float volume, float pitch, String category, String name) {
        this.enable = enable;
        this.volume = volume;
        this.pitch = pitch;
        this.category = category;
        this.name = name;
    }

    public Sound() {
        this(false, 1.0f, 1.0f, "BLOCK", "minecraft:block.note_block.bell");
    }

    @JsonValue
    public Map<String, Object> toJson() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enable", this.enable);
        if (this.enable) {
            map.put("volume", Float.valueOf(this.volume));
            map.put("pitch", Float.valueOf(this.pitch));
            map.put("category", this.category);
            map.put("name", this.name);
        }
        return map;
    }

    @JsonCreator
    public static Sound fromJson(Map<String, Object> map) {
        boolean isEnable = Boolean.parseBoolean(String.valueOf(map.get("enable")));
        if (!isEnable) {
            return new Sound();
        }
        Object volume = map.get("volume");
        float floatVolume = volume == null ? 1.0f : Float.parseFloat(String.valueOf(volume));
        Object pitch = map.get("pitch");
        float floatPitch = pitch == null ? 1.0f : Float.parseFloat(String.valueOf(pitch));
        Object category = map.get("category");
        String stringCategory = category == null ? SoundCategory.BLOCK.name() : String.valueOf(category);
        Object name = map.get("name");
        String stringName = name == null ? Sounds.BLOCK_NOTE_BLOCK_BELL.getName().toString() : String.valueOf(name);
        return new Sound(true, floatVolume, floatPitch, stringCategory, stringName);
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }
}

