/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ban;

import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.ban.listener.BanPulseListener;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class BanModule
extends AbstractModuleCommand<Localization.Command.Ban> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final MessagePipeline messagePipeline;
    private final ProxySender proxySender;
    private final ListenerRegistry listenerRegistry;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptReason = this.addPrompt(1, Localization.Command.Prompt::getReason);
        String promptTime = this.addPrompt(2, Localization.Command.Prompt::getTime);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser(this.config().isSuggestOfflinePlayers())).optional(promptTime + " " + promptReason, this.commandParserProvider.durationReasonParser()));
        this.listenerRegistry.register(BanPulseListener.class);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String target = (String)this.getArgument(commandContext, 0);
        String promptReason = this.getPrompt(1);
        String promptTime = this.getPrompt(2);
        Optional optionalTime = commandContext.optional(promptTime + " " + promptReason);
        Pair timeReasonPair = optionalTime.orElse(Pair.of((Object)-1L, null));
        long time = (Long)timeReasonPair.first();
        String reason = (String)timeReasonPair.second();
        if (time != -1L && time < 1L) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ban::getNullTime)).build());
            return;
        }
        this.ban(fPlayer, target, time, reason);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_BAN;
    }

    @Override
    public Command.Ban config() {
        return this.fileResolver.getCommand().getBan();
    }

    @Override
    public Permission.Command.Ban permission() {
        return this.fileResolver.getPermission().getCommand().getBan();
    }

    @Override
    public Localization.Command.Ban localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getBan();
    }

    public void ban(FPlayer fPlayer, String target, long time, String reason) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ban::getNullPlayer)).build());
            return;
        }
        long databaseTime = time != -1L ? time + System.currentTimeMillis() : -1L;
        Moderation ban = this.moderationService.ban(fTarget, databaseTime, reason, fPlayer.getId());
        if (ban == null) {
            return;
        }
        this.proxySender.send(fTarget, MessageType.SYSTEM_BAN);
        this.kick(fPlayer, fTarget, ban);
        this.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().sender(fTarget)).format(this.buildFormat(ban))).moderation(ban)).range(this.config().getRange())).destination(this.config().getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeAsJson(ban))).integration(string -> this.moderationMessageFormatter.replacePlaceholders((String)string, FPlayer.UNKNOWN, ban))).build());
    }

    public BiFunction<FPlayer, Localization.Command.Ban, String> buildFormat(Moderation ban) {
        return (fReceiver, message) -> {
            String format = message.getServer();
            return this.moderationMessageFormatter.replacePlaceholders(format, (FPlayer)fReceiver, ban);
        };
    }

    public void kick(FEntity fModerator, FPlayer fTarget, Moderation ban) {
        if (this.isModuleDisabledFor(fModerator)) {
            return;
        }
        if (fModerator == null) {
            return;
        }
        Localization.Command.Ban localization = this.localization(fTarget);
        String formatPlayer = localization.getPerson();
        formatPlayer = this.moderationMessageFormatter.replacePlaceholders(formatPlayer, fTarget, ban);
        this.fPlayerService.kick(fTarget, this.messagePipeline.builder(fModerator, fTarget, formatPlayer).build());
    }

    @Inject
    @Generated
    public BanModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, ModerationMessageFormatter moderationMessageFormatter, MessagePipeline messagePipeline, ProxySender proxySender, ListenerRegistry listenerRegistry, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.messagePipeline = messagePipeline;
        this.proxySender = proxySender;
        this.listenerRegistry = listenerRegistry;
        this.commandParserProvider = commandParserProvider;
    }
}

