/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ban.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.event.player.PlayerPreLoginEvent;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.command.ban.BanModule;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.kyori.adventure.text.Component;

@Singleton
public class BanPulseListener
implements PulseListener {
    private final BanModule banModule;
    private final ModerationService moderationService;
    private final FPlayerService fPlayerService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final MessagePipeline messagePipeline;
    private final PermissionChecker permissionChecker;

    @Pulse
    public void onPlayerPreLoginEvent(PlayerPreLoginEvent event) {
        if (!this.banModule.isEnable()) {
            return;
        }
        FPlayer fPlayer = event.getPlayer();
        for (Moderation ban : this.moderationService.getValidBans(fPlayer)) {
            event.setAllowed(false);
            FPlayer fModerator = this.fPlayerService.getFPlayer(ban.getModerator());
            this.fPlayerService.loadColors(fPlayer);
            Localization.Command.Ban localization = this.banModule.localization(fPlayer);
            String formatPlayer = this.moderationMessageFormatter.replacePlaceholders(localization.getPerson(), fPlayer, ban);
            Component reason = this.messagePipeline.builder(fModerator, fPlayer, formatPlayer).build();
            event.setKickReason(reason);
            if (!this.banModule.config().isShowConnectionAttempts()) continue;
            this.banModule.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().sender(fPlayer)).format((fReceiver, message) -> {
                String format = message.getConnectionAttempt();
                return this.moderationMessageFormatter.replacePlaceholders(format, (FPlayer)fReceiver, ban);
            })).moderation(ban)).range(Range.get(Range.Type.SERVER))).filter(filter -> this.permissionChecker.check((FEntity)filter, this.banModule.getPermission()))).build());
        }
    }

    @Inject
    @Generated
    public BanPulseListener(BanModule banModule, ModerationService moderationService, FPlayerService fPlayerService, ModerationMessageFormatter moderationMessageFormatter, MessagePipeline messagePipeline, PermissionChecker permissionChecker) {
        this.banModule = banModule;
        this.moderationService = moderationService;
        this.fPlayerService = fPlayerService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.messagePipeline = messagePipeline;
        this.permissionChecker = permissionChecker;
    }
}

