/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.chatsetting.builder.DialogMenuBuilder;
import net.flectone.pulse.module.command.chatsetting.builder.InventoryMenuBuilder;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class ChatsettingModule
extends AbstractModuleCommand<Localization.Command.Chatsetting> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;
    private final ProxyRegistry proxyRegistry;
    private final Provider<DialogMenuBuilder> dialogMenuBuilderProvider;
    private final Provider<InventoryMenuBuilder> inventoryMenuBuilderProvider;
    private final SoundPlayer soundPlayer;
    @Named(value="isNewerThanOrEqualsV_1_21_6")
    private final boolean isNewerThanOrEqualsV_1_21_6;

    @Override
    public void onEnable() {
        super.onEnable();
        this.permission().getSettings().values().forEach(this::registerPermission);
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptType = this.addPrompt(1, Localization.Command.Prompt::getType);
        String promptValue = this.addPrompt(2, Localization.Command.Prompt::getValue);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).optional(promptPlayer, this.commandParserProvider.offlinePlayerParser(), this.commandParserProvider.playerSuggestionPermission(true, this.permission().getOther())).optional(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()).optional(promptValue, this.commandParserProvider.messageParser()));
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> {
            if (!this.permissionChecker.check((FEntity)context.sender(), this.permission().getOther())) {
                return Collections.emptyList();
            }
            return Arrays.stream(MessageType.values()).map(setting -> Suggestion.suggestion((String)setting.name())).toList();
        };
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String promptPlayer;
        Optional optionalPlayer;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission().getOther()) && (optionalPlayer = commandContext.optional(promptPlayer = this.getPrompt(0))).isPresent()) {
            this.executeOther(fPlayer, (String)optionalPlayer.get(), commandContext);
            return;
        }
        this.open(fPlayer, fPlayer);
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_CHATSETTING;
    }

    @Override
    public Command.Chatsetting config() {
        return this.fileResolver.getCommand().getChatsetting();
    }

    @Override
    public Permission.Command.Chatsetting permission() {
        return this.fileResolver.getPermission().getCommand().getChatsetting();
    }

    @Override
    public Localization.Command.Chatsetting localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getChatsetting();
    }

    private void executeOther(FPlayer fPlayer, String target, CommandContext<FPlayer> commandContext) {
        String messageType;
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            return;
        }
        this.fPlayerService.loadSettings(fTarget);
        String promptType = this.getPrompt(1);
        Optional optionalType = commandContext.optional(promptType);
        if (optionalType.isEmpty()) {
            this.open(fPlayer, fTarget);
            return;
        }
        SettingText settingText = SettingText.fromString((String)optionalType.get());
        if (settingText != null) {
            String promptValue = this.getPrompt(2);
            Optional optionalValue = commandContext.optional(promptValue);
            fTarget.setSetting(settingText, optionalValue.orElse(null));
            this.saveSetting(fPlayer, settingText);
            return;
        }
        fTarget.setSetting(messageType, !fTarget.isSetting(messageType = ((String)optionalType.get()).toUpperCase()));
        this.saveSetting(fPlayer, messageType);
    }

    private void open(FPlayer fPlayer, FPlayer fTarget) {
        MenuBuilder menuBuilder = this.config().getModern().isEnable() && this.isNewerThanOrEqualsV_1_21_6 ? (MenuBuilder)this.dialogMenuBuilderProvider.get() : (MenuBuilder)this.inventoryMenuBuilderProvider.get();
        menuBuilder.open(fPlayer, fTarget);
    }

    public void saveSetting(FPlayer fPlayer, String messageType) {
        this.fPlayerService.saveOrUpdateSetting(fPlayer, messageType);
        if (this.proxyRegistry.hasEnabledProxy()) {
            this.proxySender.send(fPlayer, MessageType.COMMAND_CHATSETTING);
        }
    }

    public void saveSetting(FPlayer fPlayer, SettingText settingText) {
        this.fPlayerService.saveOrUpdateSetting(fPlayer, settingText);
        if (this.proxyRegistry.hasEnabledProxy()) {
            this.proxySender.send(fPlayer, MessageType.COMMAND_CHATSETTING);
        }
    }

    public String getPlayerChat(FPlayer fTarget) {
        String currentChat = fTarget.getSetting(SettingText.CHAT_NAME);
        if (StringUtils.isEmpty((CharSequence)currentChat)) {
            return "default";
        }
        return currentChat;
    }

    public String getCheckboxMaterial(boolean enabled) {
        Command.Chatsetting.Checkbox checkbox = this.config().getCheckbox();
        return enabled ? checkbox.getEnabledMaterial() : checkbox.getDisabledMaterial();
    }

    public String getCheckboxTitle(FPlayer fPlayer, String setting, boolean enabled) {
        Localization.Command.Chatsetting.Checkbox localizationCheckbox = this.localization(fPlayer).getCheckbox();
        String statusColor = enabled ? localizationCheckbox.getEnabledColor() : localizationCheckbox.getDisabledColor();
        return Strings.CS.replace(localizationCheckbox.getTypes().getOrDefault(setting, ""), "<status_color>", statusColor);
    }

    public String getCheckboxLore(FPlayer fPlayer, boolean enabled) {
        Localization.Command.Chatsetting.Checkbox localizationCheckbox = this.localization(fPlayer).getCheckbox();
        String statusColor = enabled ? localizationCheckbox.getEnabledColor() : localizationCheckbox.getDisabledColor();
        return Strings.CS.replace(enabled ? localizationCheckbox.getEnabledHover() : localizationCheckbox.getDisabledHover(), "<status_color>", statusColor);
    }

    @Inject
    @Generated
    public ChatsettingModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider, ProxySender proxySender, ProxyRegistry proxyRegistry, Provider<DialogMenuBuilder> dialogMenuBuilderProvider, Provider<InventoryMenuBuilder> inventoryMenuBuilderProvider, SoundPlayer soundPlayer, @Named(value="isNewerThanOrEqualsV_1_21_6") boolean isNewerThanOrEqualsV_1_21_6) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
        this.proxyRegistry = proxyRegistry;
        this.dialogMenuBuilderProvider = dialogMenuBuilderProvider;
        this.inventoryMenuBuilderProvider = inventoryMenuBuilderProvider;
        this.soundPlayer = soundPlayer;
        this.isNewerThanOrEqualsV_1_21_6 = isNewerThanOrEqualsV_1_21_6;
    }
}

