/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting.builder;

import com.github.retrooper.packetevents.protocol.dialog.CommonDialogData;
import com.github.retrooper.packetevents.protocol.dialog.DialogAction;
import com.github.retrooper.packetevents.protocol.dialog.action.Action;
import com.github.retrooper.packetevents.protocol.dialog.action.DynamicCustomAction;
import com.github.retrooper.packetevents.protocol.dialog.body.PlainMessage;
import com.github.retrooper.packetevents.protocol.dialog.body.PlainMessageDialogBody;
import com.github.retrooper.packetevents.protocol.dialog.button.ActionButton;
import com.github.retrooper.packetevents.protocol.dialog.button.CommonButtonData;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.dialog.Dialog;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.chatsetting.ChatsettingModule;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.module.command.chatsetting.handler.ChatsettingHandler;
import net.flectone.pulse.module.command.chatsetting.model.SubMenuItem;
import net.flectone.pulse.platform.controller.DialogController;
import net.kyori.adventure.text.Component;

@Singleton
public class DialogMenuBuilder
implements MenuBuilder {
    private final ChatsettingModule chatsettingModule;
    private final MessagePipeline messagePipeline;
    private final DialogController dialogController;
    private final ChatsettingHandler chatsettingHandler;

    @Override
    public void open(FPlayer fPlayer, FPlayer fTarget) {
        Localization.Command.Chatsetting localization = this.chatsettingModule.localization(fPlayer);
        Component header = this.messagePipeline.builder(fPlayer, fTarget, localization.getInventory().trim()).build();
        PlainMessageDialogBody dialogBody = new PlainMessageDialogBody(new PlainMessage((Component)Component.empty(), 10));
        CommonDialogData commonDialogData = new CommonDialogData(header, null, true, false, DialogAction.CLOSE, List.of(dialogBody), List.of());
        Dialog.Builder dialogBuilder = new Dialog.Builder(commonDialogData, this.chatsettingModule.config().getModern().getColumns());
        dialogBuilder = this.createDialogChatMenu(fPlayer, fTarget, dialogBuilder, localization);
        dialogBuilder = this.createDialogFColorMenu(fPlayer, fTarget, FColor.Type.SEE, dialogBuilder, this.chatsettingModule.config().getMenu().getSee(), localization.getMenu().getSee());
        dialogBuilder = this.createDialogFColorMenu(fPlayer, fTarget, FColor.Type.OUT, dialogBuilder, this.chatsettingModule.config().getMenu().getOut(), localization.getMenu().getOut());
        for (String setting : this.chatsettingModule.config().getCheckbox().getTypes().keySet()) {
            dialogBuilder = this.createDialogCheckbox(fPlayer, fTarget, setting, dialogBuilder);
        }
        this.dialogController.open(fPlayer, dialogBuilder.build(), false);
    }

    private Dialog.Builder createDialogCheckbox(FPlayer fPlayer, FPlayer fTarget, String messageType, Dialog.Builder dialogBuilder) {
        Command.Chatsetting.Checkbox checkbox = this.chatsettingModule.config().getCheckbox();
        int slot = checkbox.getTypes().get(messageType);
        if (slot == -1) {
            return dialogBuilder;
        }
        boolean enabled = fTarget.isSetting(messageType);
        String title = this.chatsettingModule.getCheckboxTitle(fPlayer, messageType, enabled);
        Component componentTitle = this.messagePipeline.builder(fPlayer, fTarget, title).build();
        String lore = this.chatsettingModule.getCheckboxLore(fPlayer, enabled);
        Component componentLore = this.messagePipeline.builder(fPlayer, fTarget, lore).build();
        String id = "fp_" + String.valueOf(UUID.randomUUID());
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.chatsettingModule.config().getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> {
            ChatsettingHandler.Status status = this.chatsettingHandler.handleCheckbox(fPlayer, fTarget, messageType);
            if (status == ChatsettingHandler.Status.DENIED) {
                return;
            }
            boolean currentEnabled = status.toBoolean();
            String invertTitle = this.chatsettingModule.getCheckboxTitle(fPlayer, messageType, !currentEnabled);
            Component componentInvertTitle = this.messagePipeline.builder(fPlayer, fTarget, invertTitle).build();
            String invertLore = this.chatsettingModule.getCheckboxLore(fPlayer, !currentEnabled);
            Component componentInvertLore = this.messagePipeline.builder(fPlayer, fTarget, invertLore).build();
            ActionButton invertButton = new ActionButton(new CommonButtonData(componentInvertTitle, componentInvertLore, this.chatsettingModule.config().getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
            this.dialogController.changeButton(fPlayer, (Dialog)dialog, id, invertButton);
            this.chatsettingModule.saveSetting(fPlayer, messageType);
        });
    }

    private Dialog.Builder createDialogChatMenu(FPlayer fPlayer, FPlayer fTarget, Dialog.Builder dialogBuilder, Localization.Command.Chatsetting localization) {
        Command.Chatsetting.Menu.Chat chat = this.chatsettingModule.config().getMenu().getChat();
        int slot = chat.getSlot();
        if (slot == -1) {
            return dialogBuilder;
        }
        String currentChat = this.chatsettingModule.getPlayerChat(fTarget);
        String[] messages = Strings.CS.replace(localization.getMenu().getChat().getItem(), "<chat>", currentChat).split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
        Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
        Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
        String id = "fp_chat";
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.chatsettingModule.config().getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> this.chatsettingHandler.handleChatMenu(fPlayer, fTarget, chat, localization, this, id));
    }

    private Dialog.Builder createDialogFColorMenu(FPlayer fPlayer, FPlayer fTarget, FColor.Type type, Dialog.Builder dialogBuilder, Command.Chatsetting.Menu.Color color, Localization.Command.Chatsetting.Menu.SubMenu subMenu) {
        int slot = color.getSlot();
        if (slot == -1) {
            return dialogBuilder;
        }
        String[] messages = subMenu.getItem().split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
        Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
        Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
        String id = "fp_fcolor_" + type.ordinal();
        ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.chatsettingModule.config().getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)id), null));
        return dialogBuilder.addButton(slot, button).addClickHandler(id, dialog -> this.chatsettingHandler.handleFColorMenu(fPlayer, fTarget, type, color, subMenu, this, id));
    }

    @Override
    public void openSubMenu(FPlayer fPlayer, FPlayer fTarget, Component header, Runnable closeConsumer, List<SubMenuItem> items, Function<SubMenuItem, String> getItemMessage, Consumer<SubMenuItem> onSelect, String id) {
        PlainMessageDialogBody dialogBody = new PlainMessageDialogBody(new PlainMessage((Component)Component.empty(), 10));
        CommonDialogData commonDialogData = new CommonDialogData(header, null, true, false, DialogAction.CLOSE, List.of(dialogBody), List.of());
        Dialog.Builder dialogBuilder = new Dialog.Builder(commonDialogData, this.chatsettingModule.config().getModern().getColumns()).addCloseConsumer(dialog -> closeConsumer.run());
        for (int i = 0; i < items.size(); ++i) {
            SubMenuItem item = items.get(i);
            String message = getItemMessage.apply(item);
            String[] messages = message.split("<br>");
            String title = messages.length > 0 ? messages[0] : "";
            String lore = messages.length > 1 ? String.join((CharSequence)"<br>", Arrays.copyOfRange(messages, 1, messages.length)) : "";
            Component componentTitle = this.messagePipeline.builder(fTarget, title).build();
            Component componentLore = this.messagePipeline.builder(fTarget, lore).build();
            String subId = id + "_" + i;
            ActionButton button = new ActionButton(new CommonButtonData(componentTitle, componentLore, this.chatsettingModule.config().getModern().getButtonWidth()), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)subId), null));
            dialogBuilder.addButton(i, button);
            dialogBuilder.addClickHandler(subId, dialog -> this.chatsettingHandler.handleSubMenu(fPlayer, item, () -> {
                onSelect.accept(item);
                this.dialogController.close(fPlayer.getUuid());
                this.open(fPlayer, fTarget);
            }));
        }
        this.dialogController.open(fPlayer, dialogBuilder.build(), false);
    }

    @Inject
    @Generated
    public DialogMenuBuilder(ChatsettingModule chatsettingModule, MessagePipeline messagePipeline, DialogController dialogController, ChatsettingHandler chatsettingHandler) {
        this.chatsettingModule = chatsettingModule;
        this.messagePipeline = messagePipeline;
        this.dialogController = dialogController;
        this.chatsettingHandler = chatsettingHandler;
    }
}

