/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.geolocate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.geolocate.model.GeolocateMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class GeolocateModule
extends AbstractModuleCommand<Localization.Command.Geolocate> {
    private static final String IP_API_URL = "http://ip-api.com/line/<ip>?fields=17031449";
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser(this.config().isSuggestOfflinePlayers())));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        List<String> response;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        FPlayer fTarget = this.fPlayerService.getFPlayer(playerName);
        if (fTarget.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Geolocate::getNullPlayer)).build());
            return;
        }
        String ip = this.platformPlayerAdapter.isOnline(fTarget) ? this.platformPlayerAdapter.getIp(fTarget) : fTarget.getIp();
        List<String> list = response = ip == null ? List.of() : this.readResponse(Strings.CS.replace(IP_API_URL, "<ip>", ip));
        if (response.isEmpty() || ((String)response.get(0)).equals("fail")) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Geolocate::getNullOrError)).build());
            return;
        }
        this.sendMessage(((GeolocateMetadata.GeolocateMetadataBuilder)((GeolocateMetadata.GeolocateMetadataBuilder)((EventMetadata.EventMetadataBuilder)((GeolocateMetadata.GeolocateMetadataBuilder)((GeolocateMetadata.GeolocateMetadataBuilder)((GeolocateMetadata.GeolocateMetadataBuilder)GeolocateMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(geolocate -> StringUtils.replaceEach((String)geolocate.getFormat(), (String[])new String[]{"<country>", "<region_name>", "<city>", "<timezone>", "<mobile>", "<proxy>", "<hosting>", "<query>"}, (String[])new String[]{(String)response.get(1), (String)response.get(2), (String)response.get(3), (String)response.get(4), (String)response.get(5), (String)response.get(6), (String)response.get(7), (String)response.get(8)}))).response(response)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_GEOLOCATE;
    }

    @Override
    public Command.Geolocate config() {
        return this.fileResolver.getCommand().getGeolocate();
    }

    @Override
    public Permission.Command.Geolocate permission() {
        return this.fileResolver.getPermission().getCommand().getGeolocate();
    }

    @Override
    public Localization.Command.Geolocate localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getGeolocate();
    }

    private List<String> readResponse(String url) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URI(url).toURL().openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                arrayList.add(line);
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return arrayList;
    }

    @Inject
    @Generated
    public GeolocateModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.commandParserProvider = commandParserProvider;
    }
}

