/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.helper;

import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class HelperModule
extends AbstractModuleCommand<Localization.Command.Helper> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ProxyRegistry proxyRegistry;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getSee());
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        Predicate<FPlayer> filter = this.getFilterSee();
        List<FPlayer> recipients = this.fPlayerService.getVisibleFPlayersFor(fPlayer).stream().filter(filter).toList();
        if (recipients.isEmpty() && this.config().isNullHelper()) {
            boolean nullHelper;
            boolean bl = nullHelper = !this.proxyRegistry.hasEnabledProxy() || this.fPlayerService.findOnlineFPlayers().stream().noneMatch(online -> this.permissionChecker.check((FEntity)online, this.permission().getSee()));
            if (nullHelper) {
                this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getNullHelper)).build());
                return;
            }
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getPlayer)).destination(this.config().getDestination())).build());
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Helper::getGlobal)).destination(this.config().getDestination())).range(this.config().getRange())).message(message)).filter(filter)).proxy(dataOutputStream -> dataOutputStream.writeString(message))).integration()).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_HELPER;
    }

    @Override
    public Command.Helper config() {
        return this.fileResolver.getCommand().getHelper();
    }

    @Override
    public Permission.Command.Helper permission() {
        return this.fileResolver.getPermission().getCommand().getHelper();
    }

    @Override
    public Localization.Command.Helper localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getHelper();
    }

    public Predicate<FPlayer> getFilterSee() {
        return fPlayer -> this.permissionChecker.check((FEntity)fPlayer, this.permission().getSee());
    }

    @Inject
    @Generated
    public HelperModule(FileResolver fileResolver, FPlayerService fPlayerService, ProxyRegistry proxyRegistry, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.proxyRegistry = proxyRegistry;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
    }
}

