/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.maintenance;

import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.status.server.WrapperStatusServerResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.maintenance.listener.MaintenancePacketListener;
import net.flectone.pulse.module.command.maintenance.listener.MaintenancePulseListener;
import net.flectone.pulse.module.command.maintenance.model.MaintenanceMetadata;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.IconUtil;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class MaintenanceModule
extends AbstractModuleCommand<Localization.Command.Maintenance> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final ListenerRegistry listenerRegistry;
    @Named(value="imagePath")
    private final Path iconPath;
    private final PlatformServerAdapter platformServerAdapter;
    private final MessagePipeline messagePipeline;
    private final IconUtil iconUtil;
    private final FLogger fLogger;
    private String icon;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getJoin());
        this.listenerRegistry.register(MaintenancePacketListener.class);
        this.listenerRegistry.register(MaintenancePulseListener.class);
        File file = this.iconPath.resolve("maintenance.png").toFile();
        if (!file.exists()) {
            this.platformServerAdapter.saveResource("images" + File.separator + "maintenance.png");
        }
        this.icon = this.iconUtil.convertIcon(file);
        if (this.config().isTurnedOn()) {
            this.kickOnlinePlayers(FPlayer.UNKNOWN);
        }
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        boolean turned = !this.config().isTurnedOn();
        this.config().setTurnedOn(turned);
        try {
            this.fileResolver.save();
        }
        catch (IOException e) {
            this.fLogger.warning(e);
            return;
        }
        this.sendMessage(((MaintenanceMetadata.MaintenanceMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)((EventMetadata.EventMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)((MaintenanceMetadata.MaintenanceMetadataBuilder)MaintenanceMetadata.builder().sender(fPlayer)).format(maintenance -> turned ? maintenance.getFormatTrue() : maintenance.getFormatFalse())).turned(turned)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
        if (turned) {
            this.kickOnlinePlayers(fPlayer);
        }
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_MAINTENANCE;
    }

    @Override
    public Command.Maintenance config() {
        return this.fileResolver.getCommand().getMaintenance();
    }

    @Override
    public Permission.Command.Maintenance permission() {
        return this.fileResolver.getPermission().getCommand().getMaintenance();
    }

    @Override
    public Localization.Command.Maintenance localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getMaintenance();
    }

    public void sendStatus(User user) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.config().isTurnedOn()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(user.getAddress().getAddress());
        this.fPlayerService.loadColors(fPlayer);
        JsonObject responseJson = new JsonObject();
        Localization.Command.Maintenance localizationMaintenance = this.localization(fPlayer);
        responseJson.add("version", this.getVersionJson(localizationMaintenance.getServerVersion()));
        responseJson.add("players", this.getPlayersJson());
        responseJson.add("description", this.messagePipeline.builder(fPlayer, localizationMaintenance.getServerDescription()).jsonSerializerBuild());
        responseJson.addProperty("favicon", "data:image/png;base64," + (this.icon == null ? "" : this.icon));
        responseJson.addProperty("enforcesSecureChat", Boolean.valueOf(false));
        WrapperStatusServerResponse wrapperStatusServerResponse = new WrapperStatusServerResponse(responseJson);
        user.sendPacket((PacketWrapper)wrapperStatusServerResponse);
    }

    public boolean isAllowed(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return true;
        }
        if (!this.config().isTurnedOn()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fPlayer, this.permission().getJoin());
    }

    private JsonElement getVersionJson(String message) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", message);
        jsonObject.addProperty("protocol", (Number)-1);
        return jsonObject;
    }

    private JsonElement getPlayersJson() {
        JsonObject playersJson = new JsonObject();
        playersJson.addProperty("max", (Number)-1);
        playersJson.addProperty("online", (Number)-1);
        playersJson.add("sample", (JsonElement)new JsonArray());
        return playersJson;
    }

    private void kickOnlinePlayers(FPlayer fSender) {
        this.fPlayerService.getOnlineFPlayers().stream().filter(filter -> !this.permissionChecker.check((FEntity)filter, this.permission().getJoin())).forEach(fReceiver -> {
            Component component = this.messagePipeline.builder(fSender, (FPlayer)fReceiver, this.localization((FEntity)fReceiver).getKick()).build();
            this.fPlayerService.kick((FPlayer)fReceiver, component);
        });
    }

    @Inject
    @Generated
    public MaintenanceModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, ListenerRegistry listenerRegistry, @Named(value="imagePath") Path iconPath, PlatformServerAdapter platformServerAdapter, MessagePipeline messagePipeline, IconUtil iconUtil, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.listenerRegistry = listenerRegistry;
        this.iconPath = iconPath;
        this.platformServerAdapter = platformServerAdapter;
        this.messagePipeline = messagePipeline;
        this.iconUtil = iconUtil;
        this.fLogger = fLogger;
    }
}

