/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.maintenance.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerPreLoginEvent;
import net.flectone.pulse.module.command.maintenance.MaintenanceModule;
import net.flectone.pulse.service.FPlayerService;
import net.kyori.adventure.text.Component;

@Singleton
public class MaintenancePulseListener
implements PulseListener {
    private final MaintenanceModule maintenanceModule;
    private final FPlayerService fPlayerService;
    private final MessagePipeline messagePipeline;

    @Pulse
    public void onPlayerPreLoginEvent(PlayerPreLoginEvent event) {
        FPlayer fPlayer = event.getPlayer();
        if (this.maintenanceModule.isAllowed(fPlayer)) {
            return;
        }
        event.setAllowed(false);
        this.fPlayerService.loadColors(fPlayer);
        String reasonMessage = this.maintenanceModule.localization(fPlayer).getKick();
        Component reason = this.messagePipeline.builder(fPlayer, reasonMessage).build();
        event.setKickReason(reason);
    }

    @Inject
    @Generated
    public MaintenancePulseListener(MaintenanceModule maintenanceModule, FPlayerService fPlayerService, MessagePipeline messagePipeline) {
        this.maintenanceModule = maintenanceModule;
        this.fPlayerService = fPlayerService;
        this.messagePipeline = messagePipeline;
    }
}

