/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.online;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.online.model.OnlineMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class OnlineModule
extends AbstractModuleCommand<Localization.Command.Online> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final TimeFormatter timeFormatter;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptType = this.addPrompt(0, Localization.Command.Prompt::getType);
        String promptPlayer = this.addPrompt(1, Localization.Command.Prompt::getPlayer);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()).required(promptPlayer, this.commandParserProvider.playerParser(this.config().isSuggestOfflinePlayers())));
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> List.of(Suggestion.suggestion((String)"first"), Suggestion.suggestion((String)"last"), Suggestion.suggestion((String)"total"));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String type = (String)this.getArgument(commandContext, 0);
        String target = (String)this.getArgument(commandContext, 1);
        FPlayer targetFPlayer = this.fPlayerService.getFPlayer(target);
        if (targetFPlayer.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Online::getNullPlayer)).build());
            return;
        }
        this.sendMessage(((OnlineMetadata.OnlineMetadataBuilder)((OnlineMetadata.OnlineMetadataBuilder)((EventMetadata.EventMetadataBuilder)((OnlineMetadata.OnlineMetadataBuilder)((OnlineMetadata.OnlineMetadataBuilder)((OnlineMetadata.OnlineMetadataBuilder)OnlineMetadata.builder().sender(targetFPlayer)).filterPlayer(fPlayer)).format(s -> switch (type) {
            case "first" -> this.timeFormatter.format(fPlayer, System.currentTimeMillis() - this.platformPlayerAdapter.getFirstPlayed(targetFPlayer), s.getFormatFirst());
            case "last" -> {
                if (this.platformPlayerAdapter.isOnline(targetFPlayer) && this.integrationModule.canSeeVanished(targetFPlayer, fPlayer)) {
                    yield s.getFormatCurrent();
                }
                yield this.timeFormatter.format(fPlayer, System.currentTimeMillis() - this.platformPlayerAdapter.getLastPlayed(targetFPlayer), s.getFormatLast());
            }
            case "total" -> this.timeFormatter.format(fPlayer, this.platformPlayerAdapter.getAllTimePlayed(targetFPlayer), s.getFormatTotal());
            default -> "";
        })).type(type)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_ONLINE;
    }

    @Override
    public Command.Online config() {
        return this.fileResolver.getCommand().getOnline();
    }

    @Override
    public Permission.Command.Online permission() {
        return this.fileResolver.getPermission().getCommand().getOnline();
    }

    @Override
    public Localization.Command.Online localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getOnline();
    }

    @Inject
    @Generated
    public OnlineModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, TimeFormatter timeFormatter) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.timeFormatter = timeFormatter;
    }
}

