/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ping;

import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class PingModule
extends AbstractModuleCommand<Localization.Command.Ping> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).optional(promptPlayer, this.commandParserProvider.platformPlayerParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        FPlayer fTarget;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String promptPlayer = this.getPrompt(0);
        Optional optionalTarget = commandContext.optional(promptPlayer);
        FPlayer fPlayer2 = fTarget = optionalTarget.isPresent() ? this.fPlayerService.getFPlayer((String)optionalTarget.get()) : fPlayer;
        if (!this.platformPlayerAdapter.isOnline(fTarget) || !this.integrationModule.canSeeVanished(fTarget, fPlayer) && !fPlayer.equals(fTarget)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Ping::getNullPlayer)).build());
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fTarget)).filterPlayer(fPlayer)).format(Localization.Command.Ping::getFormat)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_PING;
    }

    @Override
    public Command.Ping config() {
        return this.fileResolver.getCommand().getPing();
    }

    @Override
    public Permission.Command.Ping permission() {
        return this.fileResolver.getPermission().getCommand().getPing();
    }

    @Override
    public Localization.Command.Ping localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getPing();
    }

    @Inject
    @Generated
    public PingModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, PlatformPlayerAdapter platformPlayerAdapter) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

