/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.reply;

import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.tell.TellModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class ReplyModule
extends AbstractModuleCommand<Localization.Command.Reply> {
    private final FileResolver fileResolver;
    private final TellModule tellModule;
    private final CommandParserProvider commandParserProvider;
    private final SoundPlayer soundPlayer;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String receiverName = this.tellModule.getSenderReceiverMap().get(fPlayer.getUuid());
        if (receiverName == null) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Reply::getNullReceiver)).build());
            return;
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.tellModule.send(fPlayer, receiverName, message);
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_REPLY;
    }

    @Override
    public Command.Reply config() {
        return this.fileResolver.getCommand().getReply();
    }

    @Override
    public Permission.Command.Reply permission() {
        return this.fileResolver.getPermission().getCommand().getReply();
    }

    @Override
    public Localization.Command.Reply localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getReply();
    }

    @Inject
    @Generated
    public ReplyModule(FileResolver fileResolver, TellModule tellModule, CommandParserProvider commandParserProvider, SoundPlayer soundPlayer) {
        this.fileResolver = fileResolver;
        this.tellModule = tellModule;
        this.commandParserProvider = commandParserProvider;
        this.soundPlayer = soundPlayer;
    }
}

