/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.stream;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.stream.listener.StreamPulseListener;
import net.flectone.pulse.module.command.stream.model.StreamMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

@Singleton
public class StreamModule
extends AbstractModuleCommand<Localization.Command.Stream>
implements PulseListener {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptType = this.addPrompt(0, Localization.Command.Prompt::getType);
        String promptUrl = this.addPrompt(1, Localization.Command.Prompt::getUrl);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion()).optional(promptUrl, this.commandParserProvider.nativeMessageParser()));
        this.listenerRegistry.register(StreamPulseListener.class);
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> List.of(Suggestion.suggestion((String)"start"), Suggestion.suggestion((String)"end"));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        Boolean needStart;
        String type;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        switch (type = (String)this.getArgument(commandContext, 0)) {
            case "start": {
                Boolean bl = true;
                break;
            }
            case "end": {
                Boolean bl = false;
                break;
            }
            default: {
                Boolean bl = needStart = null;
            }
        }
        if (needStart == null) {
            return;
        }
        boolean isStream = ((Localization.Command.Stream)this.localization()).getPrefixTrue().equals(fPlayer.getSetting(SettingText.STREAM_PREFIX));
        if (isStream && needStart.booleanValue() && !fPlayer.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Stream::getAlready)).build());
            return;
        }
        if (!isStream && !needStart.booleanValue()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Stream::getNot)).build());
            return;
        }
        this.setStreamPrefix(fPlayer, (String)(needStart != false ? ((Localization.Command.Stream)this.localization()).getPrefixTrue() : (StringUtils.isEmpty((CharSequence)((Localization.Command.Stream)this.localization()).getPrefixFalse()) ? null : ((Localization.Command.Stream)this.localization()).getPrefixFalse())));
        if (needStart.booleanValue()) {
            String promptUrl = this.getPrompt(1);
            Optional optionalUrl = commandContext.optional(promptUrl);
            String rawString = optionalUrl.orElse("");
            String urls = Arrays.stream(rawString.split("\\s+")).filter(this::isUrl).collect(Collectors.joining(" "));
            this.sendMessage(((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((EventMetadata.EventMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)StreamMetadata.builder().sender(fPlayer)).format(this.replaceUrls(urls))).turned(true)).urls(urls)).range(this.config().getRange())).destination(this.config().getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeString(urls))).integration(string -> Strings.CS.replace(string, "<urls>", StringUtils.defaultString((String)urls)))).build());
        } else {
            this.sendMessage(((StreamMetadata.StreamMetadataBuilder)((EventMetadata.EventMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)StreamMetadata.builder().sender(fPlayer)).format(Localization.Command.Stream::getFormatEnd)).turned(false)).destination(this.config().getDestination())).build());
        }
    }

    public void setStreamPrefix(FPlayer fPlayer, String prefix) {
        fPlayer.setSetting(SettingText.STREAM_PREFIX, prefix);
        this.fPlayerService.saveOrUpdateSetting(fPlayer, SettingText.STREAM_PREFIX);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_STREAM;
    }

    @Override
    public Command.Stream config() {
        return this.fileResolver.getCommand().getStream();
    }

    @Override
    public Permission.Command.Stream permission() {
        return this.fileResolver.getPermission().getCommand().getStream();
    }

    @Override
    public Localization.Command.Stream localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getStream();
    }

    public void addTag(MessageContext messageContext) {
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.STREAM_PREFIX, (argumentQueue, context) -> {
            String streamPrefix = fPlayer.getSetting(SettingText.STREAM_PREFIX);
            if (StringUtils.isEmpty((CharSequence)streamPrefix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)streamPrefix);
        });
    }

    public Function<Localization.Command.Stream, String> replaceUrls(String string) {
        return message -> {
            List<String> urls = Arrays.stream(string.split(" ")).map(url -> Strings.CS.replace(message.getUrlTemplate(), "<url>", url)).toList();
            return Strings.CS.replace(message.getFormatStart(), "<urls>", String.join((CharSequence)"<br>", urls));
        };
    }

    private boolean isUrl(String string) {
        try {
            new URI(string).toURL();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Inject
    @Generated
    public StreamModule(FileResolver fileResolver, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.listenerRegistry = listenerRegistry;
    }
}

