/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.stream.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.module.command.stream.StreamModule;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class StreamPulseListener
implements PulseListener {
    private final StreamModule streamModule;

    @Pulse(priority=Event.Priority.HIGH)
    public void onPlayerLoadEvent(PlayerLoadEvent event) {
        boolean hasStreamPermission;
        FPlayer fPlayer = event.getPlayer();
        boolean bl = hasStreamPermission = !this.streamModule.isModuleDisabledFor(fPlayer);
        if (fPlayer.getSetting(SettingText.STREAM_PREFIX) != null) {
            if (!hasStreamPermission) {
                this.streamModule.setStreamPrefix(fPlayer, null);
            }
            return;
        }
        if (!hasStreamPermission) {
            return;
        }
        String prefixFalse = ((Localization.Command.Stream)this.streamModule.localization()).getPrefixFalse();
        if (StringUtils.isNotEmpty((CharSequence)prefixFalse)) {
            this.streamModule.setStreamPrefix(fPlayer, prefixFalse);
        }
    }

    @Pulse(priority=Event.Priority.HIGH)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        this.streamModule.addTag(messageContext);
    }

    @Inject
    @Generated
    public StreamPulseListener(StreamModule streamModule) {
        this.streamModule = streamModule;
    }
}

