/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.tictactoe;

import com.google.gson.Gson;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.tictactoe.model.TicTacToe;
import net.flectone.pulse.module.command.tictactoe.model.TicTacToeMetadata;
import net.flectone.pulse.module.command.tictactoe.service.TictactoeService;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.IgnoreSender;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class TictactoeModule
extends AbstractModuleCommand<Localization.Command.Tictactoe> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TictactoeService tictactoeService;
    private final ProxySender proxySender;
    private final IntegrationModule integrationModule;
    private final CommandParserProvider commandParserProvider;
    private final Gson gson;
    private final IgnoreSender ignoreSender;
    private final DisableSender disableSender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptHard = this.addPrompt(1, Localization.Command.Prompt::getHard);
        this.registerCommand(manager -> manager.required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptHard, this.commandParserProvider.booleanParser()).permission(this.permission().getName()));
        String promptId = this.addPrompt(2, Localization.Command.Prompt::getId);
        String promptMove = this.addPrompt(3, Localization.Command.Prompt::getMove);
        this.registerCustomCommand(manager -> manager.commandBuilder(this.getCommandName() + "move", new String[0]).required(promptId, this.commandParserProvider.integerParser()).required(promptMove, this.commandParserProvider.singleMessageParser()).permission(this.permission().getName()).handler(commandContext -> this.executeMove((FPlayer)commandContext.sender(), (CommandContext<FPlayer>)commandContext)));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.tictactoeService.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String receiverName = (String)this.getArgument(commandContext, 0);
        String promptHard = this.getPrompt(1);
        Optional optionalBoolean = commandContext.optional(promptHard);
        boolean isHard = optionalBoolean.orElse(true);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(receiverName);
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getNullPlayer)).build());
            return;
        }
        if (fReceiver.equals(fPlayer)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getMyself)).build());
            return;
        }
        this.fPlayerService.loadIgnoresIfOffline(fReceiver);
        if (this.ignoreSender.sendIfIgnored(fPlayer, fReceiver)) {
            return;
        }
        this.fPlayerService.loadSettingsIfOffline(fReceiver);
        if (this.disableSender.sendIfDisabled(fPlayer, fReceiver, this.messageType())) {
            return;
        }
        TicTacToe ticTacToe = this.tictactoeService.create(fPlayer, fReceiver, isHard);
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().sender(fPlayer)).format(Localization.Command.Tictactoe::getSender)).ticTacToe(ticTacToe)).gamePhase(GamePhase.CREATE)).sound(this.getModuleSound())).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, fReceiver)})).build());
        UUID metadataUUID = UUID.randomUUID();
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_TICTACTOE, dataOutputStream -> {
            dataOutputStream.writeUTF(GamePhase.CREATE.name());
            dataOutputStream.writeUTF(this.gson.toJson((Object)fReceiver));
            dataOutputStream.writeInt(ticTacToe.getId());
            dataOutputStream.writeBoolean(isHard);
        }, metadataUUID);
        if (isSent) {
            return;
        }
        this.sendCreateMessage(fPlayer, fReceiver, ticTacToe, metadataUUID);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_TICTACTOE;
    }

    @Override
    public Command.Tictactoe config() {
        return this.fileResolver.getCommand().getTictactoe();
    }

    @Override
    public Permission.Command.Tictactoe permission() {
        return this.fileResolver.getPermission().getCommand().getTictactoe();
    }

    @Override
    public Localization.Command.Tictactoe localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getTictactoe();
    }

    public void sendCreateMessage(FPlayer fPlayer, FPlayer fReceiver, TicTacToe ticTacToe, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.integrationModule.canSeeVanished(fPlayer, fReceiver) || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            return;
        }
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, false)).format(message -> String.format(message.getReceiver(), ticTacToe.getId()))).ticTacToe(ticTacToe)).gamePhase(GamePhase.CREATE)).sound(this.getModuleSound())).build());
    }

    public void sendMoveMessage(FPlayer fPlayer, FPlayer fReceiver, TicTacToe ticTacToe, int typeTitle, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.integrationModule.canSeeVanished(fPlayer, fReceiver) || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            return;
        }
        if (ticTacToe == null) {
            return;
        }
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().sender(fPlayer)).format(this.getMoveMessage(ticTacToe, fReceiver, typeTitle, move))).ticTacToe(ticTacToe)).gamePhase(GamePhase.MOVE)).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, fReceiver)})).build());
        this.sendMessage(((TicTacToeMetadata.TicTacToeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)((TicTacToeMetadata.TicTacToeMetadataBuilder)TicTacToeMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, false)).format(this.getMoveMessage(ticTacToe, fReceiver, typeTitle, move))).ticTacToe(ticTacToe)).gamePhase(GamePhase.MOVE)).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, fReceiver)})).build());
    }

    public void executeMove(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        int typeTitle;
        int tictactoeID = (Integer)this.getArgument(commandContext, 2);
        String move = (String)this.getArgument(commandContext, 3);
        TicTacToe ticTacToe = this.tictactoeService.get(tictactoeID);
        if (ticTacToe == null || ticTacToe.isEnded() || !ticTacToe.contains(fPlayer) || move.equals("create") && ticTacToe.isCreated()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongGame)).build());
            return;
        }
        if (!ticTacToe.move(fPlayer, move)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongMove)).build());
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(ticTacToe.getNextPlayer());
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            ticTacToe.setEnded(true);
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tictactoe::getWrongByPlayer)).build());
            return;
        }
        if (ticTacToe.isWin()) {
            ticTacToe.setEnded(true);
            typeTitle = 1;
            tempFPlayer = fPlayer;
            fPlayer = fReceiver;
            fReceiver = tempFPlayer;
        } else if (ticTacToe.isDraw()) {
            ticTacToe.setEnded(true);
            typeTitle = -1;
            tempFPlayer = fPlayer;
            fPlayer = fReceiver;
            fReceiver = tempFPlayer;
        } else {
            typeTitle = 0;
        }
        FPlayer finalFReceiver = fReceiver;
        UUID metadataUUID = UUID.randomUUID();
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_TICTACTOE, dataOutputStream -> {
            dataOutputStream.writeUTF(GamePhase.MOVE.name());
            dataOutputStream.writeUTF(this.gson.toJson((Object)finalFReceiver));
            dataOutputStream.writeUTF(ticTacToe.toString());
            dataOutputStream.writeInt(typeTitle);
            dataOutputStream.writeUTF(move);
        }, metadataUUID);
        if (isSent) {
            return;
        }
        this.sendMoveMessage(fPlayer, finalFReceiver, ticTacToe, typeTitle, move, metadataUUID);
    }

    public BiFunction<FPlayer, Localization.Command.Tictactoe, String> getMoveMessage(TicTacToe ticTacToe, FPlayer fPlayer, int typeTile, String move) {
        return (fResolver, message) -> {
            String title = switch (typeTile) {
                case 1 -> message.getFormatWin();
                case -1 -> message.getFormatDraw();
                default -> message.getFormatMove();
            };
            Localization.Command.Tictactoe.Symbol messageSymbol = message.getSymbol();
            String symbolFirst = messageSymbol.getFirst();
            String symbolSecond = messageSymbol.getSecond();
            String formatField = StringUtils.replaceEach((String)String.join((CharSequence)"<br>", message.getField()), (String[])new String[]{"<current_move>", "<last_move>"}, (String[])new String[]{ticTacToe.isEnded() ? "" : message.getCurrentMove(), message.getLastMove()});
            formatField = StringUtils.replaceEach((String)formatField, (String[])new String[]{"<title>", "<symbol>", "<move>"}, (String[])new String[]{title, ticTacToe.getFirstPlayer() == fPlayer.getId() ? symbolFirst : symbolSecond, move});
            String symbolEmpty = messageSymbol.getBlank();
            String symbolFirstRemove = messageSymbol.getFirstRemove();
            String symbolFirstWin = messageSymbol.getFirstWin();
            String symbolSecondRemove = messageSymbol.getSecondRemove();
            String symbolSecondWin = messageSymbol.getSecondWin();
            return ticTacToe.build(formatField, symbolFirst, symbolFirstRemove, symbolFirstWin, symbolSecond, symbolSecondRemove, symbolSecondWin, String.format(symbolEmpty, ticTacToe.getId()));
        };
    }

    @Inject
    @Generated
    public TictactoeModule(FileResolver fileResolver, FPlayerService fPlayerService, TictactoeService tictactoeService, ProxySender proxySender, IntegrationModule integrationModule, CommandParserProvider commandParserProvider, Gson gson, IgnoreSender ignoreSender, DisableSender disableSender) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.tictactoeService = tictactoeService;
        this.proxySender = proxySender;
        this.integrationModule = integrationModule;
        this.commandParserProvider = commandParserProvider;
        this.gson = gson;
        this.ignoreSender = ignoreSender;
        this.disableSender = disableSender;
    }

    public static enum GamePhase {
        CREATE,
        MOVE;

    }
}

