/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.toponline;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class ToponlineModule
extends AbstractModuleCommand<Localization.Command.Toponline> {
    private final FileResolver fileResolver;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final CommandParserProvider commandParserProvider;
    private final MessagePipeline messagePipeline;
    private final EventDispatcher eventDispatcher;
    private final TimeFormatter timeFormatter;
    private final SoundPlayer soundPlayer;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptNumber = this.addPrompt(0, Localization.Command.Prompt::getNumber);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).optional(promptNumber, this.commandParserProvider.integerParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        int perPage;
        List<PlatformPlayerAdapter.PlayedTimePlayer> playedTimePlayers;
        int size;
        int countPage;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String promptNumber = this.getPrompt(0);
        Optional optionalNumber = commandContext.optional(promptNumber);
        int page = optionalNumber.orElse(1);
        if (page > (countPage = (int)Math.ceil((double)(size = (playedTimePlayers = this.platformPlayerAdapter.getPlayedTimePlayers().stream().sorted(Comparator.comparing(PlatformPlayerAdapter.PlayedTimePlayer::playedTime).reversed()).toList()).size()) / (double)(perPage = this.config().getPerPage()))) || page < 1) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Toponline::getNullPage)).build());
            return;
        }
        List finalPlayedTimePlayers = playedTimePlayers.stream().skip((long)(page - 1) * (long)perPage).limit(perPage).toList();
        Localization.Command.Toponline localization = this.localization(fPlayer);
        String header = Strings.CS.replace(localization.getHeader(), "<count>", String.valueOf(size));
        Component component = this.messagePipeline.builder(fPlayer, header).build().append((Component)Component.newline());
        for (PlatformPlayerAdapter.PlayedTimePlayer timePlayer : finalPlayedTimePlayers) {
            String line = StringUtils.replaceEach((String)localization.getLine(), (String[])new String[]{"<time_player>", "<time>"}, (String[])new String[]{timePlayer.name(), this.timeFormatter.format(fPlayer, timePlayer.playedTime())});
            component = component.append(this.messagePipeline.builder(fPlayer, line).build()).append((Component)Component.newline());
        }
        String footer = StringUtils.replaceEach((String)localization.getFooter(), (String[])new String[]{"<command>", "<prev_page>", "<next_page>", "<current_page>", "<last_page>"}, (String[])new String[]{"/" + this.getCommandName(), String.valueOf(page - 1), String.valueOf(page + 1), String.valueOf(page), String.valueOf(countPage)});
        component = component.append(this.messagePipeline.builder(fPlayer, footer).build());
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.COMMAND_TOPONLINE, fPlayer, component));
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_TOPONLINE;
    }

    @Override
    public Command.Toponline config() {
        return this.fileResolver.getCommand().getToponline();
    }

    @Override
    public Permission.Command.Toponline permission() {
        return this.fileResolver.getPermission().getCommand().getToponline();
    }

    @Override
    public Localization.Command.Toponline localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getToponline();
    }

    @Inject
    @Generated
    public ToponlineModule(FileResolver fileResolver, PlatformPlayerAdapter platformPlayerAdapter, CommandParserProvider commandParserProvider, MessagePipeline messagePipeline, EventDispatcher eventDispatcher, TimeFormatter timeFormatter, SoundPlayer soundPlayer) {
        this.fileResolver = fileResolver;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.commandParserProvider = commandParserProvider;
        this.messagePipeline = messagePipeline;
        this.eventDispatcher = eventDispatcher;
        this.timeFormatter = timeFormatter;
        this.soundPlayer = soundPlayer;
    }
}

