/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.try_;

import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.try_.model.TryMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.execution.CommandExecutionHandler;

@Singleton
public class TryModule
extends AbstractModuleCommand<Localization.Command.Try> {
    private final FileResolver fileResolver;
    private final RandomUtil randomUtil;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()).handler((CommandExecutionHandler)this));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        int min = this.config().getMin();
        int max = this.config().getMax();
        int random = this.randomUtil.nextInt(min, max);
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)TryMetadata.builder().sender(fPlayer)).format(this.replacePercent(random))).percent(random)).range(this.config().getRange())).destination(this.config().getDestination())).message(message)).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeInt(random);
            dataOutputStream.writeString(message);
        })).integration(string -> Strings.CS.replace(string, "<percent>", String.valueOf(random)))).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_TRY;
    }

    @Override
    public Command.Try config() {
        return this.fileResolver.getCommand().getTry();
    }

    @Override
    public Permission.Command.Try permission() {
        return this.fileResolver.getPermission().getCommand().getTry();
    }

    @Override
    public Localization.Command.Try localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getTry();
    }

    public Function<Localization.Command.Try, String> replacePercent(int value) {
        return message -> Strings.CS.replace(value >= this.config().getGood() ? message.getFormatTrue() : message.getFormatFalse(), "<percent>", String.valueOf(value));
    }

    @Inject
    @Generated
    public TryModule(FileResolver fileResolver, RandomUtil randomUtil, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.randomUtil = randomUtil;
        this.commandParserProvider = commandParserProvider;
    }
}

