/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.unwarn;

import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.UnModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;
import org.incendo.cloud.context.CommandContext;

@Singleton
public class UnwarnModule
extends AbstractModuleCommand<Localization.Command.Unwarn> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptId = this.addPrompt(1, Localization.Command.Prompt::getId);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.warnedParser()).optional(promptId, this.commandParserProvider.integerParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String target = (String)this.getArgument(commandContext, 0);
        String promptId = this.getPrompt(1);
        Optional optionalId = commandContext.optional(promptId);
        int id = optionalId.orElse(-1);
        this.unwarn(fPlayer, target, id);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_UNWARN;
    }

    @Override
    public Command.Unwarn config() {
        return this.fileResolver.getCommand().getUnwarn();
    }

    @Override
    public Permission.Command.Unwarn permission() {
        return this.fileResolver.getPermission().getCommand().getUnwarn();
    }

    @Override
    public Localization.Command.Unwarn localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getUnwarn();
    }

    public void unwarn(FPlayer fPlayer, String target, int id) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Unwarn::getNullPlayer)).build());
            return;
        }
        ArrayList<Moderation> warns = new ArrayList<Moderation>();
        if (id == -1) {
            warns.addAll(this.moderationService.getValidWarns(fTarget));
        } else {
            this.moderationService.getValidWarns(fTarget).stream().filter(warn -> warn.getId() == id).findAny().ifPresent(warns::add);
        }
        if (warns.isEmpty()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Unwarn::getNotWarned)).build());
            return;
        }
        this.moderationService.remove(fTarget, warns);
        this.proxySender.send(fTarget, MessageType.SYSTEM_WARN);
        this.sendMessage(((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)UnModerationMetadata.builder().sender(fTarget)).format(unwarn -> Strings.CS.replace(unwarn.getFormat(), "<moderator>", fPlayer.getName()))).moderator(fPlayer)).moderations(warns)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeAsJson(fPlayer);
            dataOutputStream.writeAsJson(warns);
        })).integration(string -> Strings.CS.replace(string, "<moderator>", fPlayer.getName()))).build());
    }

    @Inject
    @Generated
    public UnwarnModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, CommandParserProvider commandParserProvider, ProxySender proxySender) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
    }
}

