/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.deepl.DeeplModule;
import net.flectone.pulse.module.integration.discord.DiscordModule;
import net.flectone.pulse.module.integration.geyser.GeyserModule;
import net.flectone.pulse.module.integration.luckperms.LuckPermsModule;
import net.flectone.pulse.module.integration.plasmovoice.PlasmoVoiceModule;
import net.flectone.pulse.module.integration.simplevoice.SimpleVoiceModule;
import net.flectone.pulse.module.integration.skinsrestorer.SkinsRestorerModule;
import net.flectone.pulse.module.integration.telegram.TelegramModule;
import net.flectone.pulse.module.integration.twitch.TwitchModule;
import net.flectone.pulse.module.integration.yandex.YandexModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;

public abstract class IntegrationModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final FLogger fLogger;
    private final PlatformServerAdapter platformServerAdapter;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    protected IntegrationModule(FileResolver fileResolver, FLogger fLogger, PlatformServerAdapter platformServerAdapter, ReflectionResolver reflectionResolver, Injector injector) {
        this.fileResolver = fileResolver;
        this.fLogger = fLogger;
        this.platformServerAdapter = platformServerAdapter;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }

    @Override
    public void configureChildren() {
        super.configureChildren();
        if (this.platformServerAdapter.hasProject("SkinsRestorer")) {
            this.addChildren(SkinsRestorerModule.class);
        }
        if (this.platformServerAdapter.hasProject("LuckPerms")) {
            this.addChildren(LuckPermsModule.class);
        }
        if (this.platformServerAdapter.hasProject("voicechat")) {
            this.addChildren(SimpleVoiceModule.class);
        }
        if (this.platformServerAdapter.hasProject("PlasmoVoice")) {
            if (this.reflectionResolver.hasClass("su.plo.voice.api.server.event.audio.source.ServerSourceCreatedEvent")) {
                this.addChildren(PlasmoVoiceModule.class);
            } else {
                this.fLogger.warning("Update PlasmoVoice to the latest version");
            }
        }
        if (this.platformServerAdapter.hasProject("Geyser-Spigot") || this.platformServerAdapter.hasProject("geyser-fabric")) {
            this.addChildren(GeyserModule.class);
        }
        this.addChildren(DeeplModule.class);
        this.addChildren(DiscordModule.class);
        this.addChildren(TelegramModule.class);
        this.addChildren(TwitchModule.class);
        this.addChildren(YandexModule.class);
    }

    @Override
    public Integration config() {
        return this.fileResolver.getIntegration();
    }

    @Override
    public Permission.Integration permission() {
        return this.fileResolver.getPermission().getIntegration();
    }

    public abstract String checkMention(FEntity var1, String var2);

    public abstract boolean isVanished(FEntity var1);

    public abstract boolean hasSeeVanishPermission(FEntity var1);

    public abstract boolean sendMessageWithInteractiveChat(FEntity var1, Component var2);

    public abstract boolean isMuted(FPlayer var1);

    public abstract ExternalModeration getMute(FPlayer var1);

    public abstract String getTritonLocale(FPlayer var1);

    public boolean isBedrockPlayer(FEntity fPlayer) {
        if (!this.isEnable()) {
            return false;
        }
        if (this.getChildren().contains(GeyserModule.class)) {
            return ((GeyserModule)this.injector.getInstance(GeyserModule.class)).isBedrockPlayer(fPlayer);
        }
        return false;
    }

    public boolean hasFPlayerPermission(FPlayer fPlayer, String permission) {
        if (!this.isEnable()) {
            return false;
        }
        if (this.getChildren().contains(LuckPermsModule.class)) {
            return ((LuckPermsModule)this.injector.getInstance(LuckPermsModule.class)).hasLuckPermission(fPlayer, permission);
        }
        return false;
    }

    public String getTextureUrl(FEntity sender) {
        if (!this.isEnable()) {
            return null;
        }
        if (!this.getChildren().contains(SkinsRestorerModule.class)) {
            return null;
        }
        if (!(sender instanceof FPlayer)) {
            return null;
        }
        FPlayer fPlayer = (FPlayer)sender;
        return ((SkinsRestorerModule)this.injector.getInstance(SkinsRestorerModule.class)).getTextureUrl(fPlayer);
    }

    public PlayerHeadObjectContents.ProfileProperty getProfileProperty(FEntity sender) {
        if (!this.isEnable()) {
            return null;
        }
        if (!this.getChildren().contains(SkinsRestorerModule.class)) {
            return null;
        }
        if (!(sender instanceof FPlayer)) {
            return null;
        }
        FPlayer fPlayer = (FPlayer)sender;
        return ((SkinsRestorerModule)this.injector.getInstance(SkinsRestorerModule.class)).getProfileProperty(fPlayer);
    }

    public String getPrefix(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return null;
        }
        if (this.getChildren().contains(LuckPermsModule.class)) {
            return ((LuckPermsModule)this.injector.getInstance(LuckPermsModule.class)).getPrefix(fPlayer);
        }
        return null;
    }

    public String getSuffix(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return null;
        }
        if (this.getChildren().contains(LuckPermsModule.class)) {
            return ((LuckPermsModule)this.injector.getInstance(LuckPermsModule.class)).getSuffix(fPlayer);
        }
        return null;
    }

    public Set<String> getGroups() {
        if (!this.isEnable()) {
            return Collections.emptySet();
        }
        if (this.getChildren().contains(LuckPermsModule.class)) {
            return ((LuckPermsModule)this.injector.getInstance(LuckPermsModule.class)).getGroups();
        }
        return Collections.emptySet();
    }

    public int getGroupWeight(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return 0;
        }
        if (!this.getChildren().contains(LuckPermsModule.class)) {
            return 0;
        }
        return ((LuckPermsModule)this.injector.getInstance(LuckPermsModule.class)).getGroupWeight(fPlayer);
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> discordString) {
        if (this.getChildren().contains(DiscordModule.class) && !MessageType.FROM_DISCORD_TO_MINECRAFT.name().equals(messageName)) {
            ((DiscordModule)this.injector.getInstance(DiscordModule.class)).sendMessage(sender, messageName, discordString);
        }
        if (this.getChildren().contains(TwitchModule.class) && !MessageType.FROM_TWITCH_TO_MINECRAFT.name().equals(messageName)) {
            ((TwitchModule)this.injector.getInstance(TwitchModule.class)).sendMessage(sender, messageName, discordString);
        }
        if (this.getChildren().contains(TelegramModule.class) && !MessageType.FROM_TELEGRAM_TO_MINECRAFT.name().equals(messageName)) {
            ((TelegramModule)this.injector.getInstance(TelegramModule.class)).sendMessage(sender, messageName, discordString);
        }
    }

    public boolean hasMessenger() {
        return ((DiscordModule)this.injector.getInstance(DiscordModule.class)).isEnable() || ((TwitchModule)this.injector.getInstance(TwitchModule.class)).isEnable() || ((TelegramModule)this.injector.getInstance(TelegramModule.class)).isEnable();
    }

    public boolean canSeeVanished(FEntity fTarget, FEntity fViewer) {
        if (fTarget.equals(fViewer)) {
            return true;
        }
        boolean isVanished = this.isVanished(fTarget);
        return !isVanished || this.hasSeeVanishPermission(fViewer);
    }

    public String deeplTranslate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        if (this.getChildren().contains(DeeplModule.class)) {
            return ((DeeplModule)this.injector.getInstance(DeeplModule.class)).translate(sender, source, target, text);
        }
        return text;
    }

    public String yandexTranslate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        if (this.getChildren().contains(YandexModule.class)) {
            return ((YandexModule)this.injector.getInstance(YandexModule.class)).translate(sender, source, target, text);
        }
        return text;
    }
}

