/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord;

import java.util.function.UnaryOperator;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.discord.DiscordIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class DiscordModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;
    private final FLogger fLogger;

    @Override
    public void onEnable() {
        super.onEnable();
        this.reflectionResolver.hasClassOrElse("discord4j.core.DiscordClient", this::loadLibraries);
        try {
            ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).hook();
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).unhook();
    }

    @Override
    public Integration.Discord config() {
        return this.fileResolver.getIntegration().getDiscord();
    }

    @Override
    public Permission.Integration.Discord permission() {
        return this.fileResolver.getPermission().getIntegration().getDiscord();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}discord4j").artifactId("discord4j-core").version("3.3.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> discordString) {
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        ((DiscordIntegration)this.injector.getInstance(DiscordIntegration.class)).sendMessage(sender, messageName, discordString);
    }

    @Inject
    @Generated
    public DiscordModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
        this.fLogger = fLogger;
    }
}

